/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZConversation;
import com.zimbra.client.ZEmailAddress;
import com.zimbra.cs.taglib.bean.BeanUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ZConversationBean {
    private ZConversation mConv;
    private List<ZMessageSummaryBean> mSummaries;

    public ZConversationBean(ZConversation conv) {
        this.mConv = conv;
    }

    public String getId() {
        return this.mConv.getId();
    }

    public boolean getHasFlags() {
        return this.mConv.hasFlags();
    }

    public boolean getHasMultipleTags() {
        return this.mConv.hasTags() && this.mConv.getTagIds().indexOf(44) != -1;
    }

    public String getTagIds() {
        return this.mConv.getTagIds();
    }

    public boolean getHasTags() {
        return this.mConv.hasTags();
    }

    public boolean getIsUnread() {
        return this.mConv.isUnread();
    }

    public boolean getIsFlagged() {
        return this.mConv.isFlagged();
    }

    public boolean getIsDraft() {
        return this.mConv.isDraft();
    }

    public boolean getIsRepliedTo() {
        return this.mConv.isRepliedTo();
    }

    public boolean getIsForwarded() {
        return this.mConv.isForwarded();
    }

    public boolean getIsSentByMe() {
        return this.mConv.isSentByMe();
    }

    public boolean getHasAttachment() {
        return this.mConv.hasAttachment();
    }

    public String getSubject() {
        return this.mConv.getSubject();
    }

    public int getMessageCount() {
        return this.mConv.getMessageCount();
    }

    public List<ZMessageSummaryBean> getMessageSummaries() {
        if (this.mSummaries == null) {
            this.mSummaries = new ArrayList<ZMessageSummaryBean>(this.mConv.getMessageSummaries().size());
            for (ZConversation.ZMessageSummary summ : this.mConv.getMessageSummaries()) {
                this.mSummaries.add(new ZMessageSummaryBean(summ));
            }
        }
        return this.mSummaries;
    }

    public static class ZMessageSummaryBean {
        private ZConversation.ZMessageSummary mSummary;

        public ZMessageSummaryBean(ZConversation.ZMessageSummary summary) {
            this.mSummary = summary;
        }

        public String getId() {
            return this.mSummary.getId();
        }

        public String getFlags() {
            return this.mSummary.getFlags();
        }

        public long getSize() {
            return this.mSummary.getSize();
        }

        public ZEmailAddress getSender() {
            return this.mSummary.getSender();
        }

        public String getDisplaySender() {
            return BeanUtils.getAddr(this.getSender());
        }

        public String getFragment() {
            return this.mSummary.getFragment();
        }

        public Date getDate() {
            return new Date(this.mSummary.getDate());
        }

        public String getTagIds() {
            return this.mSummary.getTagIds();
        }
    }
}

