/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.google.common.base.Strings;
import com.zimbra.client.ZContactHit;
import com.zimbra.client.ZEmailAddress;
import com.zimbra.client.ZSearchHit;
import com.zimbra.cs.taglib.bean.ZSearchHitBean;

public class ZContactHitBean
extends ZSearchHitBean {
    private final ZContactHit mHit;

    public ZContactHitBean(ZContactHit hit) {
        super((ZSearchHit)hit, ZSearchHitBean.HitType.contact);
        this.mHit = hit;
    }

    public String getFlags() {
        return this.mHit.getFlags();
    }

    public boolean getHasFlags() {
        return this.mHit.hasFlags();
    }

    public boolean getIsFlagged() {
        return this.mHit.isFlagged();
    }

    public boolean getHasTags() {
        return this.mHit.hasTags();
    }

    public boolean getIsGroup() {
        return this.mHit.isGroup();
    }

    public String getTagIds() {
        return this.mHit.getTagIds();
    }

    public String getFolderId() {
        return this.mHit.getFolderId();
    }

    public String getRevision() {
        return this.mHit.getRevision();
    }

    public String getFileAsStr() {
        return this.mHit.getFileAsStr();
    }

    public String getEmail() {
        return this.mHit.getEmail();
    }

    public String getEmail2() {
        return this.mHit.getEmail2();
    }

    public String getEmail3() {
        return this.mHit.getEmail3();
    }

    public String getWorkEmail1() {
        return this.mHit.getWorkEmail1();
    }

    public String getWorkEmail2() {
        return this.mHit.getWorkEmail2();
    }

    public String getWorkEmail3() {
        return this.mHit.getWorkEmail3();
    }

    public String getType() {
        return this.mHit.getType();
    }

    public String getDlist() {
        return this.mHit.getDlist();
    }

    public String toString() {
        return this.mHit.toString();
    }

    public String getFullName() {
        return this.mHit.getFullName();
    }

    public String getFileAs() {
        return this.mHit.getFileAs();
    }

    public String getNickname() {
        return this.mHit.getNickname();
    }

    public String getNamePrefix() {
        return this.mHit.getNamePrefix();
    }

    public String getFirstName() {
        return this.mHit.getFirstName();
    }

    public String getPhoneticFirstName() {
        return this.mHit.getPhoneticFirstName();
    }

    public String getMiddleName() {
        return this.mHit.getMiddleName();
    }

    public String getMaidenName() {
        return this.mHit.getMaidenName();
    }

    public String getLastName() {
        return this.mHit.getLastName();
    }

    public String getPhoneticLastName() {
        return this.mHit.getPhoneticLastName();
    }

    public String getNameSuffix() {
        return this.mHit.getNameSuffix();
    }

    public String getCompany() {
        return this.mHit.getCompany();
    }

    public String getPhoneticCompany() {
        return this.mHit.getPhoneticCompany();
    }

    public long getMetaDataChangedDate() {
        return this.mHit.getMetaDataChangedDate();
    }

    public String getDisplayEmail() {
        if (this.getIsGroup()) {
            return this.getDlist();
        }
        if (this.getEmail() != null && this.getEmail().length() > 0) {
            return this.getEmail();
        }
        if (this.getEmail2() != null && this.getEmail2().length() > 0) {
            return this.getEmail2();
        }
        if (this.getEmail3() != null && this.getEmail3().length() > 0) {
            return this.getEmail3();
        }
        return "";
    }

    public String getFullAddress() {
        if (this.getIsGroup()) {
            return this.getDlist();
        }
        String commentPart = this.getFullName();
        if (Strings.isNullOrEmpty((String)commentPart)) {
            commentPart = Strings.nullToEmpty((String)this.getFileAsStr());
        }
        return new ZEmailAddress(this.getDisplayEmail(), null, commentPart, "t").getFullAddress();
    }

    public String getImage() {
        if (this.getIsGroup()) {
            return "contacts/ImgGroup.png";
        }
        return "contacts/ImgContact.png";
    }

    public String getImageAltKey() {
        if (this.getIsGroup()) {
            return "ALT_CONTACT_GROUP";
        }
        return "ALT_CONTACT_CONTACT";
    }
}

