/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZContact;
import com.zimbra.client.ZEmailAddress;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.mailbox.Contact;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ZContactBean
implements Comparable {
    private ZContact mContact;
    private String mFileAs;
    private boolean mIsGalContact;
    private static final Pattern sCOMMA = Pattern.compile(",");
    private static final Pattern sCOMMA_OR_SP = Pattern.compile("[, ]");

    public ZContactBean(ZContact contact) {
        this.mContact = contact;
    }

    public ZContactBean(ZContact contact, boolean isGalContact) {
        this.mContact = contact;
        this.mIsGalContact = isGalContact;
    }

    public boolean getIsTypeI() {
        return this.mContact.isTypeI();
    }

    public boolean getIsGalContact() {
        return this.mIsGalContact;
    }

    public String getId() {
        return this.mContact.getId();
    }

    public String getRefId() {
        return this.mContact.getRefId();
    }

    public String getTagIds() {
        return this.mContact.getTagIds();
    }

    public String getFlags() {
        return this.mContact.getFlags();
    }

    public boolean getHasFlags() {
        return this.mContact.hasFlags();
    }

    public boolean getHasTags() {
        return this.mContact.hasTags();
    }

    public boolean getIsFlagged() {
        return this.mContact.isFlagged();
    }

    public boolean getHasAttachment() {
        return this.mContact.hasAttachment();
    }

    public String getFolderId() {
        return this.mContact.getFolderId();
    }

    public String getRevision() {
        return this.mContact.getRevision();
    }

    public long getMetaDataChangedDate() {
        return this.mContact.getMetaDataChangedDate();
    }

    public Map<String, String> getAttrs() {
        return this.mContact.getAttrs();
    }

    public String getAssistantPhone() {
        return (String)this.mContact.getAttrs().get("assistantPhone");
    }

    public String getBirthday() {
        return (String)this.mContact.getAttrs().get("birthday");
    }

    public String getCallbackPhone() {
        return (String)this.mContact.getAttrs().get("callbackPhone");
    }

    public String getCarPhone() {
        return (String)this.mContact.getAttrs().get("carPhone");
    }

    public String getCompany() {
        return (String)this.mContact.getAttrs().get("company");
    }

    public String getCompanyPhone() {
        return (String)this.mContact.getAttrs().get("companyPhone");
    }

    public String getDescription() {
        return (String)this.mContact.getAttrs().get("description");
    }

    public String getDepartment() {
        return (String)this.mContact.getAttrs().get("department");
    }

    public String getEmail() {
        return (String)this.mContact.getAttrs().get("email");
    }

    public String getEmail2() {
        return (String)this.mContact.getAttrs().get("email2");
    }

    public String getEmail3() {
        return (String)this.mContact.getAttrs().get("email3");
    }

    public String getFileAs() {
        return (String)this.mContact.getAttrs().get("fileAs");
    }

    public String getFirstName() {
        return (String)this.mContact.getAttrs().get("firstName");
    }

    public String getFullName() {
        return (String)this.mContact.getAttrs().get("fullName");
    }

    public String getHomeCity() {
        return (String)this.mContact.getAttrs().get("homeCity");
    }

    public String getHomeCountry() {
        return (String)this.mContact.getAttrs().get("homeCountry");
    }

    public String getHomeFax() {
        return (String)this.mContact.getAttrs().get("homeFax");
    }

    public String getHomePhone() {
        return (String)this.mContact.getAttrs().get("homePhone");
    }

    public String getHomePhone2() {
        return (String)this.mContact.getAttrs().get("homePhone2");
    }

    public String getHomePostalCode() {
        return (String)this.mContact.getAttrs().get("homePostalCode");
    }

    public String getHomeState() {
        return (String)this.mContact.getAttrs().get("homeState");
    }

    public String getHomeStreet() {
        return (String)this.mContact.getAttrs().get("homeStreet");
    }

    public String getHomeURL() {
        return (String)this.mContact.getAttrs().get("homeURL");
    }

    public String getInitials() {
        return (String)this.mContact.getAttrs().get("initials");
    }

    public String getJobTitle() {
        return (String)this.mContact.getAttrs().get("jobTitle");
    }

    public String getLastName() {
        return (String)this.mContact.getAttrs().get("lastName");
    }

    public String getMaidenName() {
        return (String)this.mContact.getAttrs().get("maidenName");
    }

    public String getMiddleName() {
        return (String)this.mContact.getAttrs().get("middleName");
    }

    public String getMobilePhone() {
        return (String)this.mContact.getAttrs().get("mobilePhone");
    }

    public String getNamePrefix() {
        return (String)this.mContact.getAttrs().get("namePrefix");
    }

    public String getNameSuffix() {
        return (String)this.mContact.getAttrs().get("nameSuffix");
    }

    public String getNickname() {
        return (String)this.mContact.getAttrs().get("nickname");
    }

    public String getNotes() {
        return (String)this.mContact.getAttrs().get("notes");
    }

    public String getOffice() {
        return (String)this.mContact.getAttrs().get("office");
    }

    public String getOtherCity() {
        return (String)this.mContact.getAttrs().get("otherCity");
    }

    public String getOtherCountry() {
        return (String)this.mContact.getAttrs().get("otherCountry");
    }

    public String getOtherFax() {
        return (String)this.mContact.getAttrs().get("otherFax");
    }

    public String getOtherPhone() {
        return (String)this.mContact.getAttrs().get("otherPhone");
    }

    public String getOtherPostalCode() {
        return (String)this.mContact.getAttrs().get("otherPostalCode");
    }

    public String getOtherState() {
        return (String)this.mContact.getAttrs().get("otherState");
    }

    public String getOtherStreet() {
        return (String)this.mContact.getAttrs().get("otherStreet");
    }

    public String getOtherURL() {
        return (String)this.mContact.getAttrs().get("otherURL");
    }

    public String getPager() {
        return (String)this.mContact.getAttrs().get("pager");
    }

    public String getPhoneticFirstName() {
        return (String)this.mContact.getAttrs().get("phoneticFirstName");
    }

    public String getPhoneticLastName() {
        return (String)this.mContact.getAttrs().get("phoneticLastName");
    }

    public String getPhoneticCompany() {
        return (String)this.mContact.getAttrs().get("phoneticCompany");
    }

    public String getTollFree() {
        return (String)this.mContact.getAttrs().get("tollFree");
    }

    public String getWorkCity() {
        return (String)this.mContact.getAttrs().get("workCity");
    }

    public String getWorkCountry() {
        return (String)this.mContact.getAttrs().get("workCountry");
    }

    public String getWorkFax() {
        return (String)this.mContact.getAttrs().get("workFax");
    }

    public String getWorkPhone() {
        return (String)this.mContact.getAttrs().get("workPhone");
    }

    public String getWorkPhone2() {
        return (String)this.mContact.getAttrs().get("workPhone2");
    }

    public String getWorkPostalCode() {
        return (String)this.mContact.getAttrs().get("workPostalCode");
    }

    public String getWorkState() {
        return (String)this.mContact.getAttrs().get("workState");
    }

    public String getWorkStreet() {
        return (String)this.mContact.getAttrs().get("workStreet");
    }

    public String getWorkURL() {
        return (String)this.mContact.getAttrs().get("workURL");
    }

    public boolean getIsGroup() {
        return this.mContact.getIsGroup();
    }

    public String getImagePart() {
        return this.mContact.getAttachmentPartInfo("image") != null ? this.mContact.getAttachmentPartName("image") : null;
    }

    public String getHomeAddress() {
        return (String)this.mContact.getAttrs().get("homeAddress");
    }

    public String getOtherDepartment() {
        return (String)this.mContact.getAttrs().get("otherDepartment");
    }

    public String getOtherOffice() {
        return (String)this.mContact.getAttrs().get("otherOffice");
    }

    public String getOtherProfession() {
        return (String)this.mContact.getAttrs().get("otherProfession");
    }

    public String getOtherAddress() {
        return (String)this.mContact.getAttrs().get("otherAddress");
    }

    public String getOtherMgrName() {
        return (String)this.mContact.getAttrs().get("otherMgrName");
    }

    public String getOtherAsstName() {
        return (String)this.mContact.getAttrs().get("otherAsstName");
    }

    public String getOtherAnniversary() {
        return (String)this.mContact.getAttrs().get("anniversary");
    }

    public String getOtherCustom1() {
        return (String)this.mContact.getAttrs().get("custom1");
    }

    public String getOtherCustom2() {
        return (String)this.mContact.getAttrs().get("otherCustom2");
    }

    public String getOtherCustom3() {
        return (String)this.mContact.getAttrs().get("otherCustom3");
    }

    public String getOtherCustom4() {
        return (String)this.mContact.getAttrs().get("otherCustom4");
    }

    public String getWorkAddress() {
        return (String)this.mContact.getAttrs().get("workAddress");
    }

    public String getWorkAltPhone() {
        return (String)this.mContact.getAttrs().get("workAltPhone");
    }

    public String getWorkMobile() {
        return (String)this.mContact.getAttrs().get("workMobile");
    }

    public String getIMAddress1() {
        return (String)this.mContact.getAttrs().get("imAddress1");
    }

    public String getIMAddress2() {
        return (String)this.mContact.getAttrs().get("imAddress2");
    }

    public String getIMAddress3() {
        return (String)this.mContact.getAttrs().get("imAddress3");
    }

    public String getWorkEmail2() {
        return (String)this.mContact.getAttrs().get("workEmail2");
    }

    public String getWorkEmail3() {
        return (String)this.mContact.getAttrs().get("workEmail3");
    }

    public String getWorkIM1() {
        return (String)this.mContact.getAttrs().get("workIM1");
    }

    public String getWorkIM2() {
        return (String)this.mContact.getAttrs().get("workIM2");
    }

    public String getWorkEmail1() {
        return (String)this.mContact.getAttrs().get("workEmail1");
    }

    public String[] getGroupMembers() throws ServiceException {
        Map members = this.mContact.getMembers();
        if (members != null) {
            String[] memberIds = members.keySet().toArray(new String[0]);
            return memberIds;
        }
        return null;
    }

    public List<ZContactBean> getGroupMemberList() throws ServiceException {
        Map members = this.mContact.getMembers();
        if (members != null) {
            ArrayList<ZContactBean> memberList = new ArrayList<ZContactBean>();
            for (ZContact value : members.values()) {
                memberList.add(new ZContactBean(value));
            }
            return memberList;
        }
        return null;
    }

    public static ZContactBean getGroupMemberById(ZContactBean contact, String id) throws ServiceException {
        ZContact memberContact;
        Map members = contact.mContact.getMembers();
        if (members != null && (memberContact = (ZContact)members.get(id)) != null) {
            return new ZContactBean(memberContact, memberContact.isGalContact());
        }
        return null;
    }

    public String getGroupMembersPerLine() throws ServiceException {
        StringBuilder sb = new StringBuilder();
        for (String addr : this.getGroupMembers()) {
            sb.append(addr).append("\n");
        }
        return sb.toString();
    }

    public String getMemberAddresses() throws ServiceException {
        LinkedList<String> addresses = new LinkedList<String>();
        for (ZContact member : this.mContact.getMembers().values()) {
            String address = member.isTypeI() ? member.getId() : new ZEmailAddress(member.getDisplayEmail(), null, Contact.getFileAsString((Map)member.getAttrs()), "t").getFullAddress();
            if (address == null) continue;
            addresses.add(address);
        }
        return StringUtil.join((String)", ", addresses);
    }

    public String getDisplayFileAs() {
        if (this.mFileAs == null) {
            try {
                this.mFileAs = Contact.getFileAsString((Map)this.mContact.getAttrs());
            }
            catch (ServiceException e) {
                this.mFileAs = "";
            }
        }
        return this.mFileAs;
    }

    public static boolean anySet(ZContactBean cbean, String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        String[] fields = sCOMMA_OR_SP.split(s);
        Map<String, String> attrs = cbean.getAttrs();
        for (String field : fields) {
            if (attrs.get(field) == null) continue;
            return true;
        }
        return false;
    }

    public String getFullAddress() {
        return new ZEmailAddress(this.mContact.getDisplayEmail(), null, this.getDisplayFileAs(), "t").getFullAddress();
    }

    public String getGalFileAsStr() {
        String fname = this.getFullName();
        if (fname == null || fname.length() == 0) {
            String f = this.getFirstName();
            String l = this.getLastName();
            StringBuilder sb = new StringBuilder();
            if (f != null) {
                sb.append(f);
            }
            if (l != null) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(l);
            }
            fname = sb.toString();
        }
        return fname;
    }

    public String getGalFullAddress() {
        return new ZEmailAddress(this.mContact.getDisplayEmail(), null, this.getGalFileAsStr(), "t").getFullAddress();
    }

    public String getImage() {
        if (this.getIsGroup()) {
            return "contacts/ImgGroup.png";
        }
        if (this.getIsGalContact()) {
            return "startup/ImgGALContact.png";
        }
        return "contacts/ImgContact.png";
    }

    public String getImageAltKey() {
        if (this.getIsGroup()) {
            return "ALT_CONTACT_GROUP";
        }
        if (this.getIsGalContact()) {
            return "ALT_CONTACT_GAL_CONTACT";
        }
        return "ALT_CONTACT_CONTACT";
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof ZContactBean)) {
            return 0;
        }
        ZContactBean other = (ZContactBean)obj;
        String name = this.getIsGalContact() ? this.getGalFullAddress() : this.getFullAddress();
        String oname = other.getIsGalContact() ? other.getGalFullAddress() : other.getFullAddress();
        return name.compareToIgnoreCase(oname);
    }
}

