/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZEmailAddress;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.taglib.bean.ZMessageComposeBean;
import com.zimbra.cs.taglib.bean.ZTagLibException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class ZComposeUploaderBean {
    public static final String F_attendees = "attendees";
    public static final String F_resources = "resources";
    public static final String F_apptFolderId = "apptFolderId";
    public static final String F_location = "location";
    public static final String F_timeZone = "timeZone";
    public static final String F_freeBusyStatus = "freeBusyStatus";
    public static final String F_allDay = "allDay";
    public static final String F_startDate = "startDate";
    public static final String F_startHour = "startHour";
    public static final String F_startMinute = "startMinute";
    public static final String F_endDate = "endDate";
    public static final String F_endHour = "endHour";
    public static final String F_endMinute = "endMinute";
    public static final String F_invId = "invId";
    public static final String F_exInvId = "exInvId";
    public static final String F_compNum = "compNum";
    public static final String F_instCompNum = "instCompNum";
    public static final String F_useInstance = "useInstance";
    public static final String F_instStartTime = "instStartTime";
    public static final String F_instDuration = "instDuration";
    public static final String F_inviteReplyVerb = "inviteReplyVerb";
    public static final String F_inviteReplyInst = "inviteReplyInst";
    public static final String F_inviteReplyAllDay = "inviteReplyAllDay";
    public static final String F_classProp = "classProp";
    public static final String F_taskPriority = "taskPriority";
    public static final String F_taskStatus = "taskStatus";
    public static final String F_taskPercentComplete = "taskPercentComplete";
    public static final String F_origOrganizer = "origOrganizer";
    public static final String F_recurrenceIdZ = "recurrenceIdZ";
    public static final String F_to = "to";
    public static final String F_cc = "cc";
    public static final String F_bcc = "bcc";
    public static final String F_subject = "subject";
    public static final String F_priority = "priority";
    public static final String F_messageAttachment = "messageAttachment";
    public static final String F_documentAttachment = "documentAttachment";
    public static final String F_originalAttachment = "originalAttachment";
    public static final String F_uploadedAttachment = "uploadedAttachment";
    public static final String F_body = "body";
    public static final String F_bodyText = "bodyText";
    public static final String F_replyto = "replyto";
    public static final String F_replytype = "replytype";
    public static final String F_from = "from";
    public static final String F_inreplyto = "inreplyto";
    public static final String F_messageid = "messageid";
    public static final String F_draftid = "draftid";
    public static final String F_fileUpload = "fileUpload";
    public static final String F_contactSearchQuery = "contactSearchQuery";
    public static final String F_contactSearchNameQuery = "contactSearchNameQuery";
    public static final String F_contactSearchPhoneticQuery = "contactSearchPhoneticQuery";
    public static final String F_contactSearchEmailQuery = "contactSearchEmailQuery";
    public static final String F_contactSearchDeptQuery = "contactSearchDeptQuery";
    public static final String F_contactLocation = "contactLocation";
    public static final String F_nextSearchOffset = "nextSearchOffset";
    public static final String F_prevSearchOffset = "prevSearchOffset";
    public static final String F_sendUID = "sendUID";
    public static final String F_addTo = "addTo";
    public static final String F_addCc = "addCc";
    public static final String F_addBcc = "addBcc";
    public static final String F_addAttendees = "addAttendees";
    public static final String F_addResources = "addResources";
    public static final String F_pendingTo = "pendingTo";
    public static final String F_pendingCc = "pendingCc";
    public static final String F_pendingBcc = "pendingBcc";
    public static final String F_pendingAttendees = "pendingAttendees";
    public static final String F_pendingResources = "pendingResources";
    public static final String F_actionSend = "actionSend";
    public static final String F_actionSave = "actionSave";
    public static final String F_actionCancel = "actionCancel";
    public static final String F_actionCancelConfirm = "actionCancelConfirm";
    public static final String F_actionDraft = "actionDraft";
    public static final String F_actionAutoSave = "actionAutoSave";
    public static final String F_actionApptCancel = "actionApptCancel";
    public static final String F_actionApptDelete = "actionApptDelete";
    public static final String F_actionAttachDone = "actionAttachDone";
    public static final String F_actionAttachCancel = "actionAttachCancel";
    public static final String F_actionAttachAdd = "actionAttachAdd";
    public static final String F_actionContactDone = "actionContactDone";
    public static final String F_actionContactCancel = "actionContactCancel";
    public static final String F_actionContactAdd = "actionContactAdd";
    public static final String F_actionContactSearch = "actionContactSearch";
    public static final String F_actionContactSearchMore = "actionContactSearchMore";
    public static final String F_actionContactSearchPrev = "actionContactSearchPrev";
    public static final String F_actionRepeatEdit = "actionRepeatEdit";
    public static final String F_actionRepeatCancel = "actionRepeatCancel";
    public static final String F_actionRepeatDone = "actionRepeatDone";
    public static final String F_doAction = "doAction";
    public static final String F_doComposeAction = "doComposeAction";
    public static final String F_repeatBasicType = "repeatBasicType";
    public static final String F_repeatType = "repeatType";
    public static final String F_repeatDailyInterval = "repeatDailyInterval";
    public static final String F_repeatWeeklyByDay = "repeatWeeklyByDay";
    public static final String F_repeatWeeklyInterval = "repeatWeeklyInterval";
    public static final String F_repeatWeeklySun = "repeatWeeklySun";
    public static final String F_repeatWeeklyMon = "repeatWeeklyMon";
    public static final String F_repeatWeeklyTue = "repeatWeeklyTue";
    public static final String F_repeatWeeklyWed = "repeatWeeklyWed";
    public static final String F_repeatWeeklyThu = "repeatWeeklyThu";
    public static final String F_repeatWeeklyFri = "repeatWeeklyFri";
    public static final String F_repeatWeeklySat = "repeatWeeklySat";
    public static final String F_repeatMonthlyInterval = "repeatMonthlyInterval";
    public static final String F_repeatMonthlyMonthDay = "repeatMonthlyMonthDay";
    public static final String F_repeatMonthlyRelativeInterval = "repeatMonthlyRelativeInterval";
    public static final String F_repeatMonthlyRelativeOrd = "repeatMonthlyRelativeOrd";
    public static final String F_repeatMonthlyRelativeDay = "repeatMonthlyRelativeDay";
    public static final String F_repeatYearlyMonthDay = "repeatYearlyMonthDay";
    public static final String F_repeatYearlyMonth = "repeatYearlyMonth";
    public static final String F_repeatYearlyRelativeOrd = "repeatYearlyRelativeOrd";
    public static final String F_repeatYearlyRelativeDay = "repeatYearlyRelativeDay";
    public static final String F_repeatYearlyRelativeMonth = "repeatYearlyRelativeMonth";
    public static final String F_repeatEndType = "repeatEndType";
    public static final String F_repeatEndCount = "repeatEndCount";
    public static final String F_repeatEndDate = "repeatEndDate";
    public static final String F_reminder1 = "reminderDuration1";
    public static final String F_reminder2 = "reminderDuration2";
    public static final String F_reminderEmail = "reminderEmail";
    public static final String F_reminderSendEmail = "reminderSendEmail";
    public static final String F_reminderSendMobile = "reminderSendMobile";
    public static final String F_reminderSendYIM = "reminderSendYIM";
    public static final String F_limitByFileUploadMaxSize = "lbfums";
    private static final long DEFAULT_MAX_SIZE = 0xA00000L;
    private boolean mIsUpload;
    private boolean mIsLimitExceeded = false;
    private List<FileItem> mItems;
    private ZMessageComposeBean mComposeBean;
    private String mPendingTo;
    private String mPendingCc;
    private String mPendingBcc;
    private String mPendingAttendees;
    private String mPendingResources;
    private Map<String, List<String>> mParamValues;
    private HashMap<String, String> mOrigRepeatParams;
    private boolean mIsMobile;

    public ZComposeUploaderBean(PageContext pageContext, ZMailbox mailbox, boolean isMobile) throws JspTagException, ServiceException {
        this.mIsMobile = isMobile;
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        boolean limitByFileUploadMaxSize = req.getParameter(F_limitByFileUploadMaxSize) != null;
        ServletFileUpload upload = ZComposeUploaderBean.getUploader(limitByFileUploadMaxSize);
        try {
            this.mIsUpload = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
            if (this.mIsUpload) {
                this.mParamValues = new HashMap<String, List<String>>();
                this.mOrigRepeatParams = new HashMap();
                this.mItems = upload.parseRequest(req);
                this.mComposeBean = this.getComposeBean(pageContext, this.mItems, mailbox);
            }
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            this.mIsLimitExceeded = true;
            this.mComposeBean = this.getComposeBean(pageContext, null, mailbox);
        }
        catch (FileUploadBase.InvalidContentTypeException e) {
            throw new JspTagException((Throwable)((Object)ZTagLibException.UPLOAD_FAILED(e.getMessage(), e)));
        }
        catch (FileUploadException e) {
            throw new JspTagException((Throwable)((Object)ZTagLibException.UPLOAD_FAILED(e.getMessage(), e)));
        }
    }

    private ZMessageComposeBean getComposeBean(PageContext pageContext, List<FileItem> items, ZMailbox mailbox) throws ServiceException {
        ZMessageComposeBean compose = new ZMessageComposeBean(pageContext);
        StringBuilder addTo = null;
        StringBuilder addCc = null;
        StringBuilder addBcc = null;
        StringBuilder addAttendees = null;
        StringBuilder addResources = null;
        if (items != null) {
            for (FileItem fileItem : items) {
                List<String> values;
                String value;
                if (!fileItem.isFormField()) {
                    if (!fileItem.getFieldName().equals(F_fileUpload) || fileItem.getName() == null || fileItem.getName().length() <= 0) continue;
                    compose.addFileItem(fileItem);
                    continue;
                }
                String name = fileItem.getFieldName();
                try {
                    value = fileItem.getString("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = fileItem.getString();
                }
                if (name.equals(F_messageAttachment)) {
                    int i = value.indexOf(58);
                    String id = i == -1 ? value : value.substring(0, i);
                    String subject = i == -1 ? null : value.substring(i + 1);
                    compose.getMessageAttachments().add(new ZMessageComposeBean.MessageAttachment(id, subject));
                    continue;
                }
                if (name.equals(F_documentAttachment)) {
                    String[] vals = value.split(",");
                    for (int i = 0; vals != null && i < vals.length; ++i) {
                        if (vals[i] == null || vals[i].equals("")) continue;
                        int j = vals[i].indexOf(58);
                        String id = j == -1 ? vals[i] : vals[i].substring(0, j);
                        String subject = j == -1 ? null : vals[i].substring(j + 1);
                        compose.getDocumentAttachments().add(new ZMessageComposeBean.DocumentAttachment(id, subject));
                    }
                    continue;
                }
                if (name.equals(F_originalAttachment)) {
                    String[] nameId = value.split(",");
                    if (nameId.length > 1) {
                        compose.setCheckedAttachmentName(nameId[0], nameId[1]);
                        continue;
                    }
                    compose.setCheckedAttachmentName(nameId[0], null);
                    continue;
                }
                if (name.equals(F_uploadedAttachment)) {
                    compose.setUploadedAttachment(value);
                    continue;
                }
                if (name.equals(F_addTo)) {
                    if (addTo == null) {
                        addTo = new StringBuilder();
                    }
                    if (addTo.length() > 0) {
                        addTo.append(", ");
                    }
                    addTo.append(value);
                    continue;
                }
                if (name.equals(F_addCc)) {
                    if (addCc == null) {
                        addCc = new StringBuilder();
                    }
                    if (addCc.length() > 0) {
                        addCc.append(", ");
                    }
                    addCc.append(value);
                    continue;
                }
                if (name.equals(F_addBcc)) {
                    if (addBcc == null) {
                        addBcc = new StringBuilder();
                    }
                    if (addBcc.length() > 0) {
                        addBcc.append(", ");
                    }
                    addBcc.append(value);
                    continue;
                }
                if (name.equals(F_addAttendees)) {
                    if (addAttendees == null) {
                        addAttendees = new StringBuilder();
                    }
                    if (addAttendees.length() > 0) {
                        addAttendees.append(", ");
                    }
                    addAttendees.append(value);
                    continue;
                }
                if (name.equals(F_addResources)) {
                    if (addResources == null) {
                        addResources = new StringBuilder();
                    }
                    if (addResources.length() > 0) {
                        addResources.append(", ");
                    }
                    addResources.append(value);
                    continue;
                }
                if (name.equals(F_pendingTo)) {
                    this.mPendingTo = value;
                    continue;
                }
                if (name.equals(F_pendingCc)) {
                    this.mPendingCc = value;
                    continue;
                }
                if (name.equals(F_pendingBcc)) {
                    this.mPendingBcc = value;
                    continue;
                }
                if (name.equals(F_pendingAttendees)) {
                    this.mPendingAttendees = value;
                    continue;
                }
                if (name.equals(F_pendingResources)) {
                    this.mPendingResources = value;
                    continue;
                }
                if (name.startsWith("orig_repeat")) {
                    this.mOrigRepeatParams.put(name, value);
                    continue;
                }
                if (name.startsWith("action") && name.endsWith(".x")) {
                    name = name.substring(0, name.length() - 2);
                }
                if ((values = this.mParamValues.get(name)) == null) {
                    values = new ArrayList<String>();
                    this.mParamValues.put(name, values);
                }
                values.add(value);
            }
        }
        if (this.getIsRepeatCancel()) {
            for (Map.Entry entry : this.mOrigRepeatParams.entrySet()) {
                this.mParamValues.put(((String)entry.getKey()).substring(5), Arrays.asList((String)entry.getValue()));
            }
        }
        compose.setTo(this.getParam(F_to));
        compose.setCc(this.getParam(F_cc));
        compose.setBcc(this.getParam(F_bcc));
        compose.setSubject(this.getParam(F_subject));
        compose.setPriority(this.getParam(F_priority));
        String replyType = this.getParam(F_replytype);
        if (replyType != null) {
            compose.setReplyType(replyType);
        }
        if (StringUtil.isNullOrEmpty((String)this.getParam(F_bodyText))) {
            compose.setContent(this.getParam(F_body));
        } else {
            compose.setHtmlContent(this.getParam(F_body));
            compose.setContent(this.getParam(F_bodyText));
        }
        compose.setFrom(this.getParam(F_from));
        compose.setReplyTo(this.getParam(F_replyto));
        compose.setInReplyTo(this.getParam(F_inreplyto));
        compose.setMessageId(this.getParam(F_messageid));
        compose.setDraftId(this.getParam(F_draftid));
        if (this.mIsMobile) {
            compose.setSendUID(UUID.randomUUID().toString());
        } else {
            compose.setSendUID(this.getParam(F_sendUID));
        }
        compose.setApptFolderId(this.getParam(F_apptFolderId));
        compose.setInviteReplyVerb(this.getParam(F_inviteReplyVerb));
        compose.setInviteReplyInst(this.getParamLong(F_inviteReplyInst, 0L));
        compose.setInviteReplyAllDay("1".equals(this.getParam(F_inviteReplyAllDay)));
        compose.setClassProp(this.getParam(F_classProp));
        compose.setOrigOrganizer(this.getParam(F_origOrganizer));
        compose.setTaskPriority(this.getParam(F_taskPriority));
        compose.setTaskStatus(this.getParam(F_taskStatus));
        compose.setTaskPercentComplete(this.getParam(F_taskPercentComplete));
        compose.setAttendees(this.getParam(F_attendees));
        compose.setResources(this.getParam(F_resources));
        compose.setInviteId(this.getParam(F_invId));
        compose.setCompNum(this.getParam(F_compNum));
        compose.setExceptionInviteId(this.getParam(F_exInvId));
        compose.setUseInstance("1".equals(this.getParam(F_useInstance)));
        compose.setLocation(this.getParam(F_location));
        compose.setTimeZone(this.getParam(F_timeZone));
        compose.setFreeBusyStatus(this.getParam(F_freeBusyStatus));
        compose.setAllDay("1".equals(this.getParam(F_allDay)));
        compose.setStartDate(this.getParam(F_startDate));
        compose.setStartHour(this.getParamLong(F_startHour, 0L));
        compose.setStartMinute(this.getParamLong(F_startMinute, 0L));
        compose.setEndDate(this.getParam(F_endDate));
        compose.setEndHour(this.getParamLong(F_endHour, 0L));
        compose.setEndMinute(this.getParamLong(F_endMinute, 0L));
        compose.setInstanceDuration(this.getParamLong(F_instDuration, 0L));
        compose.setInstanceStartTime(this.getParamLong(F_instStartTime, 0L));
        compose.setInstanceCompNum(this.getParam(F_instCompNum));
        compose.setRecurrenceIdZ(this.getParam(F_recurrenceIdZ));
        compose.setRepeatBasicType(this.getParam(F_repeatBasicType));
        compose.setRepeatType(this.getParam(F_repeatType));
        compose.setRepeatDailyInterval(this.getParamInt(F_repeatDailyInterval, 0));
        compose.setRepeatWeeklyByDay(this.getParamInt(F_repeatWeeklyByDay, 0));
        compose.setRepeatWeeklySun("1".equals(this.getParam(F_repeatWeeklySun)));
        compose.setRepeatWeeklyMon("1".equals(this.getParam(F_repeatWeeklyMon)));
        compose.setRepeatWeeklyTue("1".equals(this.getParam(F_repeatWeeklyTue)));
        compose.setRepeatWeeklyWed("1".equals(this.getParam(F_repeatWeeklyWed)));
        compose.setRepeatWeeklyThu("1".equals(this.getParam(F_repeatWeeklyThu)));
        compose.setRepeatWeeklyFri("1".equals(this.getParam(F_repeatWeeklyFri)));
        compose.setRepeatWeeklySat("1".equals(this.getParam(F_repeatWeeklySat)));
        compose.setRepeatWeeklyInterval(this.getParamInt(F_repeatWeeklyInterval, 0));
        compose.setRepeatMonthlyInterval(this.getParamInt(F_repeatMonthlyInterval, 0));
        compose.setRepeatMonthlyMonthDay(this.getParamInt(F_repeatMonthlyMonthDay, 0));
        compose.setRepeatMonthlyRelativeInterval(this.getParamInt(F_repeatMonthlyRelativeInterval, 0));
        compose.setRepeatMonthlyRelativeOrd(this.getParamInt(F_repeatMonthlyRelativeOrd, 0));
        compose.setRepeatMonthlyRelativeDay(this.getParamInt(F_repeatMonthlyRelativeDay, 0));
        compose.setRepeatYearlyMonthDay(this.getParamInt(F_repeatYearlyMonthDay, 0));
        compose.setRepeatYearlyMonth(this.getParamInt(F_repeatYearlyMonth, 0));
        compose.setRepeatYearlyRelativeOrd(this.getParamInt(F_repeatYearlyRelativeOrd, 0));
        compose.setRepeatYearlyRelativeDay(this.getParamInt(F_repeatYearlyRelativeDay, 0));
        compose.setRepeatYearlyRelativeMonth(this.getParamInt(F_repeatYearlyRelativeMonth, 0));
        compose.setRepeatEndType(this.getParam(F_repeatEndType));
        compose.setRepeatEndCount(this.getParamInt(F_repeatEndCount, 0));
        compose.setRepeatEndDate(this.getParam(F_repeatEndDate));
        compose.setReminder1(this.getParam(F_reminder1));
        compose.setReminder2(this.getParam(F_reminder2));
        if ("true".equals(this.getParam(F_reminderSendEmail))) {
            compose.setReminderEmail(this.getParam(F_reminderEmail));
            compose.setSendReminderEmail(true);
        } else {
            compose.setSendReminderEmail(false);
        }
        compose.setSendReminderMobile("true".equals(this.getParam(F_reminderSendMobile)));
        compose.setSendReminderYIM("true".equals(this.getParam(F_reminderSendYIM)));
        if (this.getIsContactDone()) {
            if (this.mPendingTo != null) {
                compose.setTo(this.addToList(compose.getTo(), this.mPendingTo));
            }
            if (this.mPendingCc != null) {
                compose.setCc(this.addToList(compose.getCc(), this.mPendingCc));
            }
            if (this.mPendingBcc != null) {
                compose.setBcc(this.addToList(compose.getBcc(), this.mPendingBcc));
            }
            if (this.mPendingAttendees != null) {
                compose.setAttendees(this.addToList(compose.getAttendees(), this.mPendingAttendees));
            }
            if (this.mPendingResources != null) {
                compose.setResources(this.addToList(compose.getResources(), this.mPendingResources));
            }
            if (addTo != null) {
                compose.setTo(this.addToList(compose.getTo(), addTo.toString()));
            }
            if (addCc != null) {
                compose.setCc(this.addToList(compose.getCc(), addCc.toString()));
            }
            if (addBcc != null) {
                compose.setBcc(this.addToList(compose.getBcc(), addBcc.toString()));
            }
            if (addAttendees != null) {
                compose.setAttendees(this.addToList(compose.getAttendees(), addAttendees.toString()));
            }
            if (addResources != null) {
                compose.setResources(this.addToList(compose.getResources(), addResources.toString()));
            }
        } else {
            if (addTo != null) {
                this.mPendingTo = this.addToList(this.mPendingTo, addTo.toString());
            }
            if (addCc != null) {
                this.mPendingCc = this.addToList(this.mPendingCc, addCc.toString());
            }
            if (addBcc != null) {
                this.mPendingBcc = this.addToList(this.mPendingBcc, addBcc.toString());
            }
            if (addAttendees != null) {
                this.mPendingAttendees = this.addToList(this.mPendingAttendees, addAttendees.toString());
            }
            if (addResources != null) {
                this.mPendingResources = this.addToList(this.mPendingResources, addResources.toString());
            }
        }
        if (this.getIsRepeatEdit()) {
            for (Map.Entry<String, List<String>> entry : this.mParamValues.entrySet()) {
                if (!entry.getKey().startsWith("repeat")) continue;
                this.mOrigRepeatParams.put("orig_" + entry.getKey(), entry.getValue().get(0));
            }
            compose.initRepeat(compose.getSimpleRecurrence(), compose.getApptStartCalendar().getTime(), pageContext, mailbox);
        }
        return compose;
    }

    private String addToList(String currentValue, String newValue) {
        if (currentValue != null) {
            currentValue = currentValue.trim();
        }
        if (currentValue != null && currentValue.length() > 1) {
            if (currentValue.charAt(currentValue.length() - 1) == ',') {
                return currentValue + " " + newValue;
            }
            return currentValue + ", " + newValue;
        }
        return newValue;
    }

    public List<FileItem> getItems() {
        return this.mItems;
    }

    public boolean hasParam(String name) {
        return this.mParamValues.get(name) != null;
    }

    public long getParamLong(String name, long defaultValue) {
        String v = this.getParam(name);
        if (v != null) {
            try {
                return Long.parseLong(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int getParamInt(String name, int defaultValue) {
        String v = this.getParam(name);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getParam(String name) {
        List<String> values = this.mParamValues.get(name);
        return values == null ? null : values.get(0);
    }

    public List<String> getParamValueList(String name) {
        return this.mParamValues.get(name);
    }

    public Map<String, List<String>> getParamValues() {
        return this.mParamValues;
    }

    public Map<String, String> getOrigRepeatValues() {
        return this.mOrigRepeatParams;
    }

    public boolean getIsUpload() {
        return this.mIsUpload;
    }

    public boolean getIsLimitExceeded() {
        return this.mIsLimitExceeded;
    }

    public ZMessageComposeBean getCompose() {
        return this.mComposeBean;
    }

    public boolean getIsCancel() {
        return this.hasParam(F_actionCancel);
    }

    public boolean getIsCancelConfirm() {
        return this.hasParam(F_actionCancelConfirm);
    }

    public boolean getIsApptCancel() {
        return this.hasParam(F_actionApptCancel);
    }

    public boolean getIsApptDelete() {
        return this.hasParam(F_actionApptDelete);
    }

    public boolean getIsDraft() {
        return this.hasParam(F_actionDraft);
    }

    public boolean getIsAutoSave() {
        return this.hasParam(F_actionAutoSave);
    }

    public boolean getIsSend() {
        return this.hasParam(F_actionSend);
    }

    public boolean getIsSave() {
        return this.hasParam(F_actionSave);
    }

    public boolean getIsAttachCancel() {
        return this.hasParam(F_actionAttachCancel);
    }

    public boolean getIsAttachDone() {
        return this.hasParam(F_actionAttachDone);
    }

    public boolean getIsAttachAdd() {
        return this.hasParam(F_actionAttachAdd);
    }

    public boolean getIsContactCancel() {
        return this.hasParam(F_actionContactCancel);
    }

    public boolean getIsContactDone() {
        return this.hasParam(F_actionContactDone);
    }

    public boolean getIsContactAdd() {
        return this.hasParam(F_actionContactAdd);
    }

    public boolean getIsContactSearch() {
        return this.hasParam(F_actionContactSearch);
    }

    public boolean getIsContactSearchMore() {
        return this.hasParam(F_actionContactSearchMore);
    }

    public boolean getIsContactSearchPrev() {
        return this.hasParam(F_actionContactSearchPrev);
    }

    public boolean getIsRepeatEdit() {
        return this.hasParam(F_actionRepeatEdit);
    }

    public boolean getIsRepeatCancel() {
        return this.hasParam(F_actionRepeatCancel);
    }

    public boolean getIsRepeatDone() {
        return this.hasParam(F_actionRepeatDone);
    }

    public boolean getHasChanged() {
        return this.mIsUpload && (this.getIsRepeatDone() || this.getIsContactDone());
    }

    public String getContactSearchQuery() {
        return this.getParam(F_contactSearchQuery);
    }

    public String getContactSearchNameQuery() {
        return this.getParam(F_contactSearchNameQuery);
    }

    public String getContactSearchPhoneticQuery() {
        return this.getParam(F_contactSearchPhoneticQuery);
    }

    public String getContactSearchEmailQuery() {
        return this.getParam(F_contactSearchEmailQuery);
    }

    public String getContactSearchDeptQuery() {
        return this.getParam(F_contactSearchDeptQuery);
    }

    public String getPendingTo() {
        return this.mPendingTo;
    }

    public String getPendingCc() {
        return this.mPendingCc;
    }

    public String getPendingBcc() {
        return this.mPendingBcc;
    }

    public String getPendingAttendees() {
        return this.mPendingAttendees;
    }

    public String getPendingResources() {
        return this.mPendingResources;
    }

    public void setPendingAttendees(String mPendingAttendees) {
        this.mPendingAttendees = mPendingAttendees;
    }

    public void setPendingResources(String mPendingresources) {
        this.mPendingResources = mPendingresources;
    }

    public String getContactLocation() {
        return this.getParam(F_contactLocation);
    }

    public String getNextSearchOffset() {
        return this.getParam(F_nextSearchOffset);
    }

    public String getPrevSearchOffset() {
        return this.getParam(F_prevSearchOffset);
    }

    public List<ZEmailAddress> getPendingAttendeesList() {
        try {
            if (this.mPendingAttendees != null && this.mPendingAttendees.length() > 0) {
                return ZEmailAddress.parseAddresses((String)this.mPendingAttendees, (String)"t");
            }
        }
        catch (Exception e) {
            ZimbraLog.webclient.debug((Object)("Parse attendees failed for:" + this.mPendingAttendees));
        }
        return null;
    }

    public List<ZEmailAddress> getPendingResourcesList() {
        try {
            if (this.mPendingResources != null && this.mPendingResources.length() > 0) {
                return ZEmailAddress.parseAddresses((String)this.mPendingResources, (String)"t");
            }
        }
        catch (Exception e) {
            ZimbraLog.webclient.debug((Object)("Parse resources failed for:" + this.mPendingResources));
        }
        return null;
    }

    public List<ZEmailAddress> getAllAttendeesAndResourcesList() {
        List<ZEmailAddress> l1 = this.getPendingAttendeesList();
        List<ZEmailAddress> l2 = this.getPendingResourcesList();
        List<ZEmailAddress> l3 = null;
        List<ZEmailAddress> l4 = null;
        try {
            l3 = this.getCompose().getAttendeesAddrs();
        }
        catch (ServiceException se) {
            ZimbraLog.webclient.debug((Object)"compose bean getAttendiesAddrs failed");
        }
        try {
            l4 = this.getCompose().getResourcesAddrs();
        }
        catch (ServiceException se) {
            ZimbraLog.webclient.debug((Object)"compose bean getResourcesAddrs failed");
        }
        if (l1 != null) {
            if (l2 != null) {
                l1.addAll(l2);
            }
            if (l3 != null) {
                l1.addAll(l3);
            }
            if (l4 != null) {
                l1.addAll(l4);
            }
            return l1;
        }
        if (l2 != null) {
            if (l3 != null) {
                l2.addAll(l3);
            }
            if (l4 != null) {
                l2.addAll(l4);
            }
            return l2;
        }
        if (l3 != null) {
            if (l4 != null) {
                l3.addAll(l4);
            }
            return l3;
        }
        return l4;
    }

    private static ServletFileUpload getUploader(boolean limitByFileUploadMaxSize) {
        ServletFileUpload upload;
        block5: {
            DiskFileItemFactory dfif = new DiskFileItemFactory();
            dfif.setSizeThreshold(32768);
            dfif.setRepository(new File(ZComposeUploaderBean.getTempDirectory()));
            upload = new ServletFileUpload((FileItemFactory)dfif);
            try {
                long maxSize;
                if (limitByFileUploadMaxSize) {
                    maxSize = Provisioning.getInstance().getLocalServer().getLongAttr("zimbraFileUploadMaxSize", 0xA00000L);
                } else {
                    maxSize = Provisioning.getInstance().getConfig().getLongAttr("zimbraMtaMaxMessageSize", 0xA00000L);
                    if (maxSize == 0L) {
                        maxSize = -1L;
                    }
                }
                upload.setSizeMax(maxSize);
            }
            catch (ServiceException e) {
                if (!ZimbraLog.webclient.isDebugEnabled()) break block5;
                ZimbraLog.webclient.debug((Object)("unable to read " + (limitByFileUploadMaxSize ? "zimbraFileUploadMaxSize" : "zimbraMtaMaxMessageSize") + "attribute" + e.getMessage()));
            }
        }
        return upload;
    }

    private static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir", "/tmp");
    }
}

