/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.cs.taglib.bean.ZApptDayLayoutBean;
import com.zimbra.cs.taglib.bean.ZApptRowLayoutBean;
import java.util.List;

public class ZApptMultiDayLayoutBean {
    private List<ZApptRowLayoutBean> mAllDayRows;
    private List<ZApptRowLayoutBean> mRows;
    private List<ZApptDayLayoutBean> mDays;
    private List<List<ZApptRowLayoutBean>> mRowsSeperatedByDays;
    private List<List<ZApptRowLayoutBean>> mAllDayRowsSeperatedByDays;
    private int mMaxColumns;

    public ZApptMultiDayLayoutBean(List<ZApptDayLayoutBean> days, List<ZApptRowLayoutBean> allDayRows, List<ZApptRowLayoutBean> rows, List<List<ZApptRowLayoutBean>> rowsSeperatedByDays, List<List<ZApptRowLayoutBean>> allDayRowsSeperatedByDays) {
        this.mAllDayRows = allDayRows;
        this.mRows = rows;
        this.mDays = days;
        this.mMaxColumns = 0;
        this.mRowsSeperatedByDays = rowsSeperatedByDays;
        this.mAllDayRowsSeperatedByDays = allDayRowsSeperatedByDays;
        for (ZApptDayLayoutBean day : days) {
            this.mMaxColumns += day.getColumns().size();
        }
    }

    public List<ZApptRowLayoutBean> getAllDayRows() {
        return this.mAllDayRows;
    }

    public List<ZApptRowLayoutBean> getRows() {
        return this.mRows;
    }

    public List<List<ZApptRowLayoutBean>> getRowsSeperatedByDays() {
        return this.mRowsSeperatedByDays;
    }

    public List<List<ZApptRowLayoutBean>> getAllDayRowsSeperatedByDays() {
        return this.mAllDayRowsSeperatedByDays;
    }

    public List<ZApptDayLayoutBean> getDays() {
        return this.mDays;
    }

    public int getNumDays() {
        return this.mDays.size();
    }

    public int getMaxColumns() {
        return this.mMaxColumns;
    }

    public long getScheduleAlldayOverlapCount() {
        int overlap = 0;
        for (ZApptDayLayoutBean day : this.mDays) {
            if (day.getAllDayAppts().isEmpty()) continue;
            ++overlap;
        }
        return overlap;
    }
}

