/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZAppointmentHit;
import com.zimbra.cs.taglib.bean.BeanUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class ZApptDayLayoutBean {
    private long mStartTime;
    private long mEndTime;
    private int mDay;
    private int mNumDays;
    private String mFolderId;
    private static final long MSECS_PER_MINUTE = 60000L;
    private static final long MSECS_PER_HOUR = 3600000L;
    private static final long MSECS_PER_DAY = 86400000L;
    public static final String PSTATUS_DECLINED = "DE";
    List<ZAppointmentHit> mAllday = new ArrayList<ZAppointmentHit>();
    List<ZAppointmentHit> mAppts = new ArrayList<ZAppointmentHit>();
    ZAppointmentHit mEarliestAppt;
    ZAppointmentHit mLatestAppt;
    List<List<ZAppointmentHit>> mColumns;

    public ZAppointmentHit getEarliestAppt() {
        return this.mEarliestAppt;
    }

    public ZAppointmentHit getLatestAppt() {
        return this.mLatestAppt;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public List<ZAppointmentHit> getAllDayAppts() {
        return this.mAllday;
    }

    public List<List<ZAppointmentHit>> getColumns() {
        return this.mColumns;
    }

    public int getDay() {
        return this.mDay;
    }

    public int getMaxColumns() {
        return this.mColumns.size();
    }

    public int getWidth() {
        return (int)(100.0 / (double)this.mNumDays);
    }

    public ZApptDayLayoutBean(List<ZAppointmentHit> appts, Calendar startCal, int day, int numDays, String folderId, long msecsIncr, boolean isShowDeclined) {
        this.mStartTime = startCal.getTimeInMillis();
        this.mEndTime = BeanUtils.addDay(startCal, 1).getTimeInMillis();
        this.mDay = day;
        this.mNumDays = numDays;
        this.mFolderId = folderId;
        for (ZAppointmentHit appt : appts) {
            if (!appt.isInRange(this.mStartTime, this.mEndTime) || this.mFolderId != null && !this.mFolderId.equals(appt.getFolderId()) || appt.getParticipantStatus() != null && (appt.getParticipantStatus() == null || appt.getParticipantStatus().equals(PSTATUS_DECLINED) && (!appt.getParticipantStatus().equals(PSTATUS_DECLINED) || !isShowDeclined))) continue;
            if (appt.isAllDay()) {
                this.mAllday.add(appt);
                continue;
            }
            this.mAppts.add(appt);
            if (this.mEarliestAppt == null || appt.getStartTime() < this.mEarliestAppt.getStartTime()) {
                this.mEarliestAppt = appt;
            }
            if (this.mLatestAppt != null && appt.getEndTime() <= this.mLatestAppt.getEndTime()) continue;
            this.mLatestAppt = appt;
        }
        this.computeOverlapInfo(msecsIncr);
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    private void computeOverlapInfo(long msecsIncr) {
        this.mColumns = new ArrayList<List<ZAppointmentHit>>();
        this.mColumns.add(new ArrayList());
        for (ZAppointmentHit appt : this.mAppts) {
            boolean overlap = false;
            for (List<ZAppointmentHit> col : this.mColumns) {
                ZAppointmentHit currentAppt;
                overlap = false;
                Iterator<ZAppointmentHit> iterator = col.iterator();
                while (iterator.hasNext() && !(overlap = appt.isOverLapping(currentAppt = iterator.next(), msecsIncr))) {
                }
                if (overlap) continue;
                col.add(appt);
                break;
            }
            if (!overlap) continue;
            ArrayList<ZAppointmentHit> newCol = new ArrayList<ZAppointmentHit>();
            newCol.add(appt);
            this.mColumns.add(newCol);
        }
    }
}

