/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.client.ZAppointmentHit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ZApptAllDayLayoutBean {
    long mStartTime;
    long mEndTime;
    int mNumDays;
    public static final String PSTATUS_DECLINED = "DE";
    List<ZAppointmentHit> mAllday = new ArrayList<ZAppointmentHit>();
    List<List<ZAppointmentHit>> mRows;

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public List<ZAppointmentHit> getAllDayAppts() {
        return this.mAllday;
    }

    public List<List<ZAppointmentHit>> getRows() {
        return this.mRows;
    }

    public Date getDate() {
        return new Date(this.mStartTime);
    }

    public int getNumberOfRows() {
        return this.mRows.size();
    }

    public ZApptAllDayLayoutBean(List<ZAppointmentHit> appts, long startTime, long endTime, int numDays, boolean scheduleMode, boolean isShowDeclined) {
        this.mStartTime = startTime;
        this.mEndTime = endTime;
        this.mNumDays = numDays;
        for (ZAppointmentHit appt : appts) {
            if (!appt.isAllDay() || !appt.isInRange(this.mStartTime, this.mEndTime) || appt.getParticipantStatus().equals(PSTATUS_DECLINED) && (!appt.getParticipantStatus().equals(PSTATUS_DECLINED) || !isShowDeclined)) continue;
            this.mAllday.add(appt);
        }
        Collections.sort(this.mAllday, new Comparator<ZAppointmentHit>(){

            @Override
            public int compare(ZAppointmentHit a1, ZAppointmentHit a2) {
                return new Long(a2.getEndTime() - ZApptAllDayLayoutBean.this.mStartTime - (a1.getEndTime() - ZApptAllDayLayoutBean.this.mStartTime)).intValue();
            }
        });
        this.computeOverlapInfo(scheduleMode);
    }

    private void computeOverlapInfo(boolean scheduleMode) {
        this.mRows = new ArrayList<List<ZAppointmentHit>>();
        this.mRows.add(new ArrayList());
        for (ZAppointmentHit appt : this.mAllday) {
            boolean overlap = false;
            for (List<ZAppointmentHit> row : this.mRows) {
                overlap = false;
                if (!scheduleMode) {
                    ZAppointmentHit currentAppt;
                    Iterator<ZAppointmentHit> iterator = row.iterator();
                    while (iterator.hasNext() && !(overlap = appt.isOverLapping(currentAppt = iterator.next()))) {
                    }
                } else {
                    for (ZAppointmentHit currentAppt : row) {
                        overlap = appt.getFolderId().equals(currentAppt.getFolderId());
                        if (!overlap) continue;
                        break;
                    }
                }
                if (overlap) continue;
                row.add(appt);
                break;
            }
            if (!overlap) continue;
            ArrayList<ZAppointmentHit> newRow = new ArrayList<ZAppointmentHit>();
            newRow.add(appt);
            this.mRows.add(newRow);
        }
    }
}

