/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import java.text.DateFormatSymbols;
import java.util.Locale;
import javax.servlet.jsp.PageContext;

class ExtendedDateFormatSymbols
extends DateFormatSymbols {
    public ExtendedDateFormatSymbols(Locale locale, PageContext pc) {
        super(locale);
        this.init(pc);
    }

    private void init(PageContext pc) {
        int i;
        String[] weekDays = new String[8];
        String[] shortWeekDays = new String[8];
        String[] months = new String[12];
        String[] shortMonths = new String[12];
        String[] dayNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        for (i = 0; i < dayNames.length; ++i) {
            weekDays[i + 1] = I18nUtil.getLocalizedMessage(pc, "weekday" + dayNames[i] + "Long", "/messages/I18nMsg");
            shortWeekDays[i + 1] = I18nUtil.getLocalizedMessage(pc, "weekday" + dayNames[i] + "Medium", "/messages/I18nMsg");
        }
        this.setWeekdays(weekDays);
        this.setShortWeekdays(shortWeekDays);
        for (i = 0; i < monthNames.length; ++i) {
            months[i] = I18nUtil.getLocalizedMessage(pc, "month" + monthNames[i] + "Long", "/messages/I18nMsg");
            shortMonths[i] = I18nUtil.getLocalizedMessage(pc, "month" + monthNames[i] + "Medium", "/messages/I18nMsg");
        }
        this.setMonths(months);
        this.setShortMonths(shortMonths);
    }
}

