/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib.bean;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.zimbra.client.ZAppointmentHit;
import com.zimbra.client.ZContactByPhoneCache;
import com.zimbra.client.ZEmailAddress;
import com.zimbra.client.ZFeatures;
import com.zimbra.client.ZFilterAction;
import com.zimbra.client.ZFilterCondition;
import com.zimbra.client.ZFilterRule;
import com.zimbra.client.ZFolder;
import com.zimbra.client.ZGetInfoResult;
import com.zimbra.client.ZInvite;
import com.zimbra.client.ZMailbox;
import com.zimbra.client.ZMountpoint;
import com.zimbra.client.ZPhone;
import com.zimbra.client.ZPhoneAccount;
import com.zimbra.client.ZShare;
import com.zimbra.client.ZSimpleRecurrence;
import com.zimbra.client.ZTag;
import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.mailbox.ContactConstants;
import com.zimbra.common.mime.shim.JavaMailInternetAddress;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.taglib.ZJspSession;
import com.zimbra.cs.taglib.bean.ExtendedDateFormatSymbols;
import com.zimbra.cs.taglib.bean.ZApptSummariesBean;
import com.zimbra.cs.taglib.bean.ZFolderBean;
import com.zimbra.cs.taglib.bean.ZMailboxBean;
import com.zimbra.cs.taglib.bean.ZMessageBean;
import com.zimbra.cs.taglib.bean.ZPhoneAccountBean;
import com.zimbra.cs.taglib.bean.ZTagBean;
import com.zimbra.cs.taglib.bean.ZUserAgentBean;
import com.zimbra.cs.taglib.bean.ZVoiceMailItemHitBean;
import com.zimbra.cs.taglib.tag.i18n.I18nUtil;
import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class BeanUtils {
    private static final Pattern sAMP = Pattern.compile("&", 8);
    private static final Pattern sTWO_SPACES = Pattern.compile("  ", 8);
    private static final Pattern sLEADING_SPACE = Pattern.compile("^ ", 8);
    private static final Pattern sTAB = Pattern.compile("\\t", 8);
    private static final Pattern sLT = Pattern.compile("<", 8);
    private static final Pattern sGT = Pattern.compile(">", 8);
    private static final Pattern sDBLQT = Pattern.compile("\"", 8);
    private static final Pattern sNL = Pattern.compile("\\r?\\n", 8);
    private static final Pattern sSTART = Pattern.compile("^", 8);
    private static final Pattern sURL = Pattern.compile("((telnet:)|((https?|ftp|gopher|news|file):\\/\\/)|(www\\.[\\w\\.\\_\\-]+))[^\\s\\xA0\\(\\)\\<\\>\\[\\]\\{\\}'\"]*", 8);
    private static final Pattern sHTMLDECODE = Pattern.compile("\\<.*?\\>", 8);
    private static final Pattern sCOMMA = Pattern.compile(",");
    private static long sUrlRandSalt = 0L;
    private static Context sEnvCtxt = null;
    private static final long MSECS_PER_MINUTE = 60000L;
    private static final long MSECS_PER_HOUR = 3600000L;
    private static final long MSECS_PER_DAY = 86400000L;
    public static Map<String, String> sPHONE_FIELDS;
    private static Pattern sPHONE_NAME;
    private static final Pattern sPHONE;
    private static Pattern sEMAIL_ADDRESS;

    private static void addAddr(StringBuilder sb, ZEmailAddress email, int size) {
        if (email == null) {
            return;
        }
        if (sb.length() > 0) {
            sb.append(", ");
        }
        if (size > 1 && email.getDisplay() != null) {
            sb.append(email.getDisplay());
        } else if (email.getPersonal() != null) {
            sb.append(email.getPersonal());
        } else if (email.getAddress() != null) {
            sb.append(email.getAddress());
        }
    }

    public static String getAddrs(List<ZEmailAddress> addrs) {
        if (addrs == null) {
            return null;
        }
        int len = addrs.size();
        StringBuilder sb = new StringBuilder();
        for (ZEmailAddress addr : addrs) {
            BeanUtils.addAddr(sb, addr, len);
        }
        String result = sb.toString();
        return result.length() == 0 ? null : result;
    }

    public static String joinLines(String lines, String sep) {
        StringBuilder result = new StringBuilder();
        for (String line : lines.split("(?m)\\n")) {
            if (line.length() <= 0) continue;
            if (result.length() > 0) {
                result.append(sep);
            }
            result.append(line);
        }
        return result.toString();
    }

    public static String replaceAll(String org, String find, String replace) {
        if (org != null && find != null && replace != null) {
            org = org.replaceAll(find, replace);
        }
        return org;
    }

    public static String getHeaderAddrs(List<ZEmailAddress> addrs, String type) {
        if (addrs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ZEmailAddress addr : addrs) {
            String a;
            String p;
            boolean useP;
            if (type == null || !addr.getType().equals(type)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            boolean bl = useP = (p = addr.getPersonal()) != null && p.length() > 0;
            if (useP) {
                sb.append(p);
            }
            if ((a = addr.getAddress()) == null || a.length() <= 0) continue;
            if (useP) {
                sb.append(" <");
            }
            sb.append(a);
            if (!useP) continue;
            sb.append('>');
        }
        String result = sb.toString();
        return result.length() == 0 ? null : result;
    }

    public static String getAddr(ZEmailAddress addr) {
        String result;
        if (addr == null) {
            return null;
        }
        if (addr.getPersonal() != null) {
            result = addr.getPersonal();
        } else if (addr.getAddress() != null) {
            result = addr.getAddress();
        } else {
            return null;
        }
        return result.length() == 0 ? null : result;
    }

    public static DateFormatSymbols getDateFormatSymbols(Locale userLocale, PageContext pc) {
        ExtendedDateFormatSymbols dfs = new ExtendedDateFormatSymbols(userLocale, pc);
        return dfs;
    }

    private static String escapeDollarSign(String value) {
        if (value == null || value.length() == 0 || value.indexOf(36) == -1) {
            return value;
        }
        return value.replace("$", "\\$");
    }

    public static void main(String[] args) {
        System.out.println(BeanUtils.escapeDollarSign("hello world"));
        System.out.println(BeanUtils.escapeDollarSign("hello$world"));
        System.out.println(BeanUtils.escapeDollarSign("hello$4"));
    }

    private static String replaceAll(String text, Pattern pattern, String replace) {
        Matcher m = pattern.matcher(text);
        StringBuffer sb = null;
        replace = BeanUtils.escapeDollarSign(replace);
        while (m.find()) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            m.appendReplacement(sb, replace);
        }
        if (sb != null) {
            m.appendTail(sb);
        }
        return sb == null ? text : sb.toString();
    }

    public static String prefixContent(String content, String prefix) {
        if (content == null || prefix == null) {
            return "";
        }
        return BeanUtils.replaceAll(content, sSTART, prefix);
    }

    public static String htmlEncode(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String s = BeanUtils.replaceAll(text, sAMP, "&amp;");
        s = BeanUtils.replaceAll(s, sLT, "&lt;");
        s = BeanUtils.replaceAll(s, sGT, "&gt;");
        return s;
    }

    public static String htmlNewlineEncode(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        return text.replaceAll("\n", "<br>");
    }

    public static String htmlDecode(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String s = BeanUtils.replaceAll(text, "<br>", "\n");
        s = BeanUtils.replaceAll(s, sHTMLDECODE, "");
        s = BeanUtils.replaceAll(s, "&amp;", "&");
        s = BeanUtils.replaceAll(s, "&nbsp;", " ");
        s = BeanUtils.replaceAll(s, "&lt;", "<");
        s = BeanUtils.replaceAll(s, "&gt;", ">");
        s = BeanUtils.replaceAll(s, "&quot;", "\"");
        return s;
    }

    public static String encodeHtmlAttr(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String s = BeanUtils.replaceAll(text, sAMP, "&amp;");
        s = BeanUtils.replaceAll(s, sLT, "&lt;");
        s = BeanUtils.replaceAll(s, sGT, "&gt;");
        s = BeanUtils.replaceAll(s, sDBLQT, "&quot;");
        return s;
    }

    public static String htmlRubyEncode(String base, String text) {
        if (base != null && base.length() > 0 && text != null && text.length() > 0) {
            StringBuilder str = new StringBuilder();
            str.append("<ruby><rb>");
            str.append(BeanUtils.htmlEncode(base));
            str.append("</rb><rp>(</rp><rt>");
            str.append(BeanUtils.htmlEncode(text));
            str.append("</rt><rp>)</rp></ruby>");
            return str.toString();
        }
        String s = base != null && base.length() > 0 ? base : (text != null && text.length() > 0 ? text : "");
        return BeanUtils.htmlEncode(s);
    }

    public static String urlEncode(String value) throws UnsupportedEncodingException {
        String encodedUrl = HttpUtil.encodePath((String)value);
        String s = BeanUtils.replaceAll(encodedUrl, ";", "%3B");
        return s;
    }

    private static String internalTextToHtml(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String s = BeanUtils.replaceAll(text, sAMP, "&amp;");
        s = BeanUtils.replaceAll(s, sTWO_SPACES, " &nbsp;");
        s = BeanUtils.replaceAll(s, sLEADING_SPACE, "&nbsp;");
        s = BeanUtils.replaceAll(s, sLT, "&lt;");
        s = BeanUtils.replaceAll(s, sGT, "&gt;");
        s = BeanUtils.replaceAll(s, sTAB, "<pre class='MsgBody-plain-tab'>\t</pre>");
        s = BeanUtils.replaceAll(s, sNL, "<br />");
        return s;
    }

    public static String textToHtml(String text) {
        if (text == null) {
            return null;
        }
        Matcher m = sURL.matcher(text);
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        while (m.find()) {
            String url;
            char last;
            if (m.start() > lastIndex) {
                sb.append(BeanUtils.internalTextToHtml(text.substring(lastIndex, m.start())));
            }
            if ((last = (url = m.group()).charAt(url.length() - 1)) == '.' || last == '!' || last == ',') {
                url = url.substring(0, url.length() - 1);
            }
            sb.append("<a class='zUrl' target='_blank' href='");
            if (url.length() > 4 && url.substring(0, 4).startsWith("www.")) {
                sb.append("http://");
            }
            sb.append(url);
            sb.append("'>");
            sb.append(BeanUtils.htmlEncode(url));
            sb.append("</a>");
            lastIndex = m.start() + url.length();
        }
        if (lastIndex < text.length()) {
            sb.append(BeanUtils.internalTextToHtml(text.substring(lastIndex)));
        }
        return sb.toString();
    }

    public static String stripHtmlComments(String html) {
        String REGEX = "<(?:!(?:--[\\s\\S]*?--\\s*)?(>)\\s*|(?:script|style|SCRIPT|STYLE)[\\s\\S]*?<\\/(?:script|style|SCRIPT|STYLE)>)";
        Pattern p = Pattern.compile(REGEX);
        Matcher m = p.matcher(html);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (m.group(1) != null) {
                m.appendReplacement(sb, " ");
                continue;
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 != null && str2 != null) {
            return str1.equalsIgnoreCase(str2);
        }
        return false;
    }

    public static String truncate(String text, int length, boolean ellipses) {
        if (text.length() < length) {
            return text;
        }
        if (length <= 0) {
            return ellipses ? "..." : "";
        }
        int n = Math.min(length, text.length());
        for (int i = n - 1; i > 0; --i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return text.substring(0, i) + (ellipses ? " ..." : "");
        }
        return text.subSequence(0, length) + (ellipses ? " ..." : "");
    }

    public static String truncateFixed(String text, int length, boolean ellipses) {
        if (length <= 0) {
            return ellipses ? "..." : "";
        }
        if (text.length() <= length) {
            return text;
        }
        String filler = ellipses ? "..." : "";
        return text.subSequence(0, length / 2) + filler + text.subSequence(text.length() - length / 2 + filler.length(), text.length());
    }

    public static String displaySize(PageContext pc, long size) {
        return BeanUtils.displaySize(pc, size, 0);
    }

    public static String displaySize(PageContext pc, long size, int fractions) {
        String units;
        double dsize;
        if (size >= 0x40000000L) {
            dsize = (double)size / 1.073741824E9;
            units = pc == null ? "GB" : I18nUtil.getLocalizedMessage(pc, "gb");
        } else if (size >= 0x100000L) {
            dsize = (double)size / 1048576.0;
            units = pc == null ? "MB" : I18nUtil.getLocalizedMessage(pc, "mb");
        } else if (size >= 1024L) {
            dsize = (double)size / 1024.0;
            units = pc == null ? "KB" : I18nUtil.getLocalizedMessage(pc, "kb");
        } else {
            dsize = size;
            units = pc == null ? "b" : I18nUtil.getLocalizedMessage(pc, "b");
        }
        Locale locale = I18nUtil.getLocale("en_US");
        if (pc != null) {
            locale = I18nUtil.findLocale(pc);
        }
        NumberFormat formatter = NumberFormat.getNumberInstance(locale);
        String str = dsize + "";
        if (fractions == 0) {
            str = formatter.format(Math.round(dsize));
        } else {
            formatter.setMaximumFractionDigits(fractions);
            str = formatter.format(dsize);
        }
        return str + " " + units;
    }

    public static String displaySizePercent(long size, long max) {
        String formt = "%";
        double dsize = (double)(size * 100L) / (double)max;
        return Math.round(dsize) + formt;
    }

    private static DateFormat getDateFormat(PageContext pc, DateTimeFmt fmt) {
        DateFormat df = (DateFormat)pc.getAttribute(fmt.name(), 2);
        if (df == null) {
            switch (fmt) {
                case DTF_DATE_MEDIUM: {
                    df = new SimpleDateFormat(I18nUtil.getLocalizedMessage(pc, "ZM_formatDateMediumNoYear"));
                    break;
                }
                case DTF_TIME_SHORT: {
                    df = DateFormat.getTimeInstance(3, pc.getRequest().getLocale());
                    break;
                }
                default: {
                    df = DateFormat.getDateInstance(3, pc.getRequest().getLocale());
                }
            }
            pc.setAttribute(fmt.name(), (Object)df, 2);
        }
        return df;
    }

    public static String displayMsgDate(PageContext pc, Date msg) throws ServiceException, JspException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        TimeZone tz = mbox.getPrefs().getTimeZone();
        Calendar cal = Calendar.getInstance(tz);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        long nowTime = cal.getTimeInMillis();
        long msgTime = msg.getTime();
        if (msgTime >= nowTime) {
            DateFormat df = BeanUtils.getDateFormat(pc, DateTimeFmt.DTF_TIME_SHORT);
            df.setTimeZone(tz);
            return df.format(msg);
        }
        long nowYear = cal.get(1);
        cal.setTimeInMillis(msgTime);
        long msgYear = cal.get(1);
        Locale locale = I18nUtil.findLocale(pc);
        if (nowYear == msgYear) {
            SimpleDateFormat df = new SimpleDateFormat(I18nUtil.getLocalizedMessage(pc, "ZM_formatDateMediumNoYear"), locale);
            df.setTimeZone(tz);
            return df.format(msg);
        }
        return BeanUtils.displayDate(pc, msg, tz);
    }

    public static String displayDate(PageContext pc, Date msg) throws ServiceException, JspException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        TimeZone tz = mbox.getPrefs().getTimeZone();
        return BeanUtils.displayDate(pc, msg, tz);
    }

    private static String displayDate(PageContext pc, Date msg, TimeZone tz) {
        DateFormat df = BeanUtils.getDateFormat(pc, DateTimeFmt.DTF_DATE_SHORT);
        df.setTimeZone(tz);
        return df.format(msg);
    }

    public static String displayDuration(PageContext pc, long duration) throws ServiceException, JspException {
        long totalSeconds = duration / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = (totalSeconds - seconds) / 60L;
        if (minutes > 0L) {
            return I18nUtil.getLocalizedMessage(pc, "durationDisplayMinutes", new Object[]{minutes, seconds});
        }
        return I18nUtil.getLocalizedMessage(pc, "durationDisplaySeconds", new Object[]{seconds});
    }

    public static String displayVoiceDate(PageContext pc, Date msg) throws ServiceException, JspException {
        int ONE_DAY = 86400000;
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        TimeZone tz = mbox.getPrefs().getTimeZone();
        Calendar nowCal = Calendar.getInstance(tz);
        Calendar msgCal = Calendar.getInstance(tz);
        long nowTime = nowCal.getTimeInMillis();
        msgCal.setTime(msg);
        long msgTime = msgCal.getTimeInMillis();
        Calendar yesterdayCal = Calendar.getInstance(tz);
        yesterdayCal.setTimeInMillis(nowTime - 86400000L);
        int nowDay = nowCal.get(5);
        int nowYesterday = yesterdayCal.get(5);
        int msgDay = msgCal.get(5);
        String resource = nowTime - msgTime < 86400000L && nowDay == msgDay ? "ZM_formatVoiceDateToday" : (nowTime - msgTime < 172800000L && nowYesterday == msgDay ? "ZM_formatVoiceDateYesterday" : "ZM_formatVoiceDate");
        DateFormat df = (DateFormat)pc.getAttribute(resource, 2);
        if (df == null) {
            df = new SimpleDateFormat(I18nUtil.getLocalizedMessage(pc, resource));
            pc.setAttribute(resource, (Object)df, 2);
        }
        df.setTimeZone(tz);
        return df.format(msgCal.getTime());
    }

    public static String getAttr(PageContext pc, String attr) throws JspException, ServiceException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        List val = (List)mbox.getAccountInfo(false).getAttrs().get(attr);
        return val.size() > 0 ? (String)val.get(0) : null;
    }

    public static boolean isProvOrAttr(PageContext pc, String attr) throws JspException, ServiceException {
        Provisioning prov = Provisioning.getInstance();
        return prov.getConfig().getBooleanAttr(attr, false) || "TRUE".equals(BeanUtils.getAttr(pc, attr));
    }

    public static String getMailURL(PageContext pc) {
        try {
            return Provisioning.getInstance().getLocalServer().getMailURL();
        }
        catch (ServiceException e) {
            return "/zimbra";
        }
    }

    public static String repeatString(String string, int count) {
        if (count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(string.length() * count);
        while (count-- > 0) {
            sb.append(string);
        }
        return sb.toString();
    }

    private static boolean inList(String id, String[] list) {
        for (String s : list) {
            if (!s.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static List<ZTagBean> getAvailableTags(PageContext pc, String idList, boolean excludeList) throws JspException {
        try {
            String[] ids = idList == null || idList.length() == 0 ? new String[]{} : sCOMMA.split(idList);
            ArrayList<ZTagBean> tags = new ArrayList<ZTagBean>();
            if (!excludeList && ids.length == 0) {
                return tags;
            }
            ZMailbox mbox = ZJspSession.getZMailbox(pc);
            List allTags = mbox.getAllTags();
            for (ZTag tag : allTags) {
                if (excludeList) {
                    if (BeanUtils.inList(tag.getId(), ids)) continue;
                    tags.add(new ZTagBean(tag));
                    continue;
                }
                if (!BeanUtils.inList(tag.getId(), ids)) continue;
                tags.add(new ZTagBean(tag));
            }
            return tags;
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public static List<ZTagBean> getTags(PageContext pc, String idList) throws JspException {
        try {
            ZMailbox mbox = ZJspSession.getZMailbox(pc);
            if (idList == null || idList.length() == 0) {
                return null;
            }
            String[] ids = sCOMMA.split(idList);
            ArrayList<ZTagBean> tags = new ArrayList<ZTagBean>(ids.length);
            for (String id : ids) {
                ZTag tag = mbox.getTagById(id);
                if (tag == null) continue;
                tags.add(new ZTagBean(tag));
            }
            return tags;
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public static String getTagNames(PageContext pc, String idList) throws JspException {
        try {
            ZMailbox mbox = ZJspSession.getZMailbox(pc);
            if (idList == null || idList.length() == 0) {
                return null;
            }
            String[] ids = sCOMMA.split(idList);
            StringBuilder sb = new StringBuilder();
            for (String id : ids) {
                ZTag tag = mbox.getTagById(id);
                if (tag == null) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(tag.getName());
            }
            return sb.toString();
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public static String getTagName(PageContext pc, String id) throws JspException {
        try {
            ZMailbox mbox = ZJspSession.getZMailbox(pc);
            if (id == null) {
                return null;
            }
            ZTag tag = mbox.getTagById(id);
            return tag == null ? null : tag.getName();
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public static String getServerName(PageContext pc) {
        String serverName = pc.getRequest().getParameter("customerDomain");
        return serverName != null ? serverName.trim() : HttpUtil.getVirtualHost((HttpServletRequest)((HttpServletRequest)pc.getRequest()));
    }

    public static ZTagBean getTag(PageContext pc, String id) throws JspException {
        try {
            ZMailbox mbox = ZJspSession.getZMailbox(pc);
            if (id == null) {
                return null;
            }
            ZTag tag = mbox.getTagById(id);
            return tag == null ? null : new ZTagBean(tag);
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public static String maskRemoteItemId(ZMailboxBean mailbox, String folderId, String id) throws JspException, ServiceException {
        return mailbox.getMailbox().maskRemoteItemId(folderId, id);
    }

    public static String unmaskRemoteItemId(ZMailboxBean mailbox, String id) throws JspException, ServiceException {
        return mailbox.getMailbox().unmaskRemoteItemId(id);
    }

    public static ZFolderBean getFolder(PageContext pc, String id) throws JspException, ServiceException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        if (id == null) {
            return null;
        }
        ZFolder f = mbox.getFolderById(id);
        if (f == null) {
            try {
                ZGetInfoResult acctInfo = mbox.getAccountInfo(false);
                String acctId = acctInfo.getId();
                ItemId itemId = new ItemId(id, acctId);
                if (!itemId.belongsTo(acctId) && (mbox = ZJspSession.getRestMailbox(pc, ZJspSession.getAuthToken(pc), itemId.getAccountId())) != null) {
                    f = mbox.getFolderById(id);
                }
            }
            catch (ServiceException se) {
                f = null;
            }
        }
        return f == null ? null : new ZFolderBean(f);
    }

    public static String getFolderName(PageContext pc, String id) throws JspException, ServiceException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        if (id == null) {
            return null;
        }
        ZFolder f = mbox.getFolderById(id);
        if (f == null) {
            return null;
        }
        String lname = I18nUtil.getLocalizedMessage(pc, "FOLDER_LABEL_" + f.getId());
        return lname == null || lname.startsWith("???") ? BeanUtils.cook(f.getName()) : lname;
    }

    public static String getUncookedFolderName(PageContext pc, String id) throws JspException, ServiceException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        if (id == null) {
            return null;
        }
        ZFolder f = mbox.getFolderById(id);
        if (f == null) {
            return null;
        }
        String lname = I18nUtil.getLocalizedMessage(pc, "FOLDER_LABEL_" + f.getId());
        return lname == null || lname.startsWith("???") ? f.getName() : lname;
    }

    public static String getTruncatedFolderName(PageContext pc, String id, int length, boolean ellipses) throws JspException, ServiceException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        if (id == null) {
            return null;
        }
        ZFolder f = mbox.getFolderById(id);
        if (f == null) {
            return null;
        }
        String lname = I18nUtil.getLocalizedMessage(pc, "FOLDER_LABEL_" + f.getId());
        String folderName = lname == null || lname.startsWith("???") ? f.getName() : lname;
        String truncatedFolderName = BeanUtils.truncate(folderName, length, ellipses);
        return BeanUtils.cook(truncatedFolderName);
    }

    private static void getFolderPath(PageContext pc, ZFolder folder, StringBuilder builder) throws JspException, ServiceException {
        ZFolder parent = folder.getParent();
        if (parent != null && !"1".equals(parent.getId())) {
            BeanUtils.getFolderPath(pc, parent, builder);
            builder.append("/");
        }
        builder.append(BeanUtils.getUncookedFolderName(pc, folder.getId()));
    }

    public static String getFolderPath(PageContext pc, String id) throws JspException, ServiceException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        if (id == null) {
            return null;
        }
        ZFolder f = mbox.getFolderById(id);
        if (f == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(256);
        BeanUtils.getFolderPath(pc, f, builder);
        return BeanUtils.cook(builder.toString());
    }

    public static String getTruncatedFolderPath(PageContext pc, String id, int length, boolean ellipses) throws JspException, ServiceException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        if (id == null) {
            return null;
        }
        ZFolder f = mbox.getFolderById(id);
        if (f == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(256);
        BeanUtils.getFolderPath(pc, f, builder);
        String folderPath = BeanUtils.truncate(builder.toString(), length, ellipses);
        return BeanUtils.cook(folderPath);
    }

    public static String getUrlRand() {
        return System.currentTimeMillis() - 1167421101179L + "." + sUrlRandSalt++;
    }

    public static String getEnvString(String key, String defaultValue) {
        try {
            String value = sEnvCtxt == null ? defaultValue : (String)sEnvCtxt.lookup(key);
            return value == null ? defaultValue : value;
        }
        catch (NamingException e) {
            return defaultValue;
        }
    }

    public static boolean isAddressBook(ZFilterCondition condition) {
        return condition instanceof ZFilterCondition.ZAddressBookCondition;
    }

    public static ZFilterCondition.ZAddressBookCondition getAddressBook(ZFilterCondition condition) {
        return BeanUtils.isAddressBook(condition) ? (ZFilterCondition.ZAddressBookCondition)condition : null;
    }

    public static boolean isAddress(ZFilterCondition condition) {
        return condition instanceof ZFilterCondition.ZAddressCondition;
    }

    public static ZFilterCondition.ZAddressCondition getAddress(ZFilterCondition condition) {
        return BeanUtils.isAddress(condition) ? (ZFilterCondition.ZAddressCondition)condition : null;
    }

    public static boolean isBody(ZFilterCondition condition) {
        return condition instanceof ZFilterCondition.ZBodyCondition;
    }

    public static ZFilterCondition.ZBodyCondition getBody(ZFilterCondition condition) {
        return BeanUtils.isBody(condition) ? (ZFilterCondition.ZBodyCondition)condition : null;
    }

    public static boolean isSize(ZFilterCondition condition) {
        return condition instanceof ZFilterCondition.ZSizeCondition;
    }

    public static ZFilterCondition.ZSizeCondition getSize(ZFilterCondition condition) {
        return BeanUtils.isSize(condition) ? (ZFilterCondition.ZSizeCondition)condition : null;
    }

    public static boolean isDate(ZFilterCondition condition) {
        return condition instanceof ZFilterCondition.ZDateCondition;
    }

    public static ZFilterCondition.ZDateCondition getDate(ZFilterCondition condition) {
        return BeanUtils.isDate(condition) ? (ZFilterCondition.ZDateCondition)condition : null;
    }

    public static boolean isHeader(ZFilterCondition condition) {
        return condition instanceof ZFilterCondition.ZHeaderCondition;
    }

    public static ZFilterCondition.ZHeaderCondition getHeader(ZFilterCondition condition) {
        return BeanUtils.isHeader(condition) ? (ZFilterCondition.ZHeaderCondition)condition : null;
    }

    public static boolean isHeaderExists(ZFilterCondition condition) {
        return condition instanceof ZFilterCondition.ZHeaderExistsCondition;
    }

    public static ZFilterCondition.ZHeaderExistsCondition getHeaderExists(ZFilterCondition condition) {
        return BeanUtils.isHeaderExists(condition) ? (ZFilterCondition.ZHeaderExistsCondition)condition : null;
    }

    public static boolean isAttachmentExists(ZFilterCondition condition) {
        return condition instanceof ZFilterCondition.ZAttachmentExistsCondition;
    }

    public static ZFilterCondition.ZAttachmentExistsCondition getAttachmentExists(ZFilterCondition condition) {
        return BeanUtils.isAttachmentExists(condition) ? (ZFilterCondition.ZAttachmentExistsCondition)condition : null;
    }

    public static boolean isCollection(Object obj) {
        return obj instanceof Object[] || obj instanceof Collection;
    }

    public static boolean isKeep(ZFilterAction action) {
        return action instanceof ZFilterAction.ZKeepAction;
    }

    public static boolean isDiscard(ZFilterAction action) {
        return action instanceof ZFilterAction.ZDiscardAction;
    }

    public static boolean isStop(ZFilterAction action) {
        return action instanceof ZFilterAction.ZStopAction;
    }

    public static boolean isFileInto(ZFilterAction action) {
        return action instanceof ZFilterAction.ZFileIntoAction;
    }

    public static ZFilterAction.ZFileIntoAction getFileInto(ZFilterAction action) {
        return BeanUtils.isFileInto(action) ? (ZFilterAction.ZFileIntoAction)action : null;
    }

    public static boolean isTag(ZFilterAction action) {
        return action instanceof ZFilterAction.ZTagAction;
    }

    public static ZFilterAction.ZTagAction getTag(ZFilterAction action) {
        return BeanUtils.isTag(action) ? (ZFilterAction.ZTagAction)action : null;
    }

    public static boolean isFlag(ZFilterAction action) {
        return action instanceof ZFilterAction.ZMarkAction;
    }

    public static ZFilterAction.ZMarkAction getFlag(ZFilterAction action) {
        return BeanUtils.isFlag(action) ? (ZFilterAction.ZMarkAction)action : null;
    }

    public static boolean isRedirect(ZFilterAction action) {
        return action instanceof ZFilterAction.ZRedirectAction;
    }

    public static ZFilterAction.ZRedirectAction getRedirect(ZFilterAction action) {
        return BeanUtils.isRedirect(action) ? (ZFilterAction.ZRedirectAction)action : null;
    }

    public static boolean isDiscardFilter(ZFilterRule rule) {
        List actions = rule.getActions();
        for (ZFilterAction action : actions) {
            if (BeanUtils.isDiscard(action) || BeanUtils.isStop(action)) continue;
            return false;
        }
        return true;
    }

    public static Calendar getCalendarMidnight(long time, TimeZone tz) {
        Calendar cal = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
        cal.setTimeInMillis(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getCalendar(long time, TimeZone tz) {
        Calendar cal = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
        cal.setTimeInMillis(time);
        return cal;
    }

    public static Calendar getToday(TimeZone tz) {
        Calendar cal = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getTodayHour(int hour, TimeZone tz) {
        Calendar cal = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(11, hour);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getCurrentTime(TimeZone tz) {
        Calendar cal = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
        cal.setTimeInMillis(System.currentTimeMillis());
        return cal;
    }

    public static Calendar getFirstDayOfMonthView(Calendar date, long prefFirstDayOfWeek) {
        ++prefFirstDayOfWeek;
        Calendar cal = Calendar.getInstance(date.getTimeZone());
        cal.setTimeInMillis(date.getTimeInMillis());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        int dow = cal.get(7);
        if ((long)dow != prefFirstDayOfWeek) {
            cal.add(5, -((dow + (7 - (int)prefFirstDayOfWeek)) % 7));
        }
        return cal;
    }

    public static Calendar getFirstDayOfMultiDayView(Calendar date, long prefFirstDayOfWeek, String view) {
        Calendar cal = Calendar.getInstance(date.getTimeZone());
        cal.setTimeInMillis(date.getTimeInMillis());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int dow = cal.get(7);
        if ("workWeek".equalsIgnoreCase(view)) {
            if (dow == 1) {
                cal.add(5, 1);
            } else if (dow != 2) {
                cal.add(5, -(dow - 2));
            }
        } else if ("week".equalsIgnoreCase(view) && (long)dow != prefFirstDayOfWeek) {
            cal.add(5, -((dow - 1 + (7 - (int)prefFirstDayOfWeek)) % 7));
        }
        return cal;
    }

    public static Calendar getStartOfMultiDayView(Calendar date, long prefFirstDayOfWeek, String view) {
        Calendar cal = Calendar.getInstance(date.getTimeZone());
        cal.setTimeInMillis(date.getTimeInMillis());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int dow = cal.get(7);
        if ((long)dow != prefFirstDayOfWeek) {
            cal.add(5, -((dow - 1 + (7 - (int)prefFirstDayOfWeek)) % 7));
        }
        return cal;
    }

    public static Calendar getCurrentDay(Calendar date) {
        Calendar cal = Calendar.getInstance(date.getTimeZone());
        cal.setTimeInMillis(date.getTimeInMillis());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static void getNextDay(Calendar cal) {
        cal.add(5, 1);
    }

    public static void setDayOfWeek(Calendar cal, int dow) {
        cal.set(7, dow);
    }

    public static void setMonth(Calendar cal, int month) {
        cal.set(2, month);
    }

    public static Calendar addDay(Calendar cal, int incr) {
        Calendar other = Calendar.getInstance(cal.getTimeZone());
        other.setTimeInMillis(cal.getTimeInMillis());
        other.add(5, incr);
        return other;
    }

    public static Calendar addMonth(Calendar cal, int incr) {
        Calendar other = Calendar.getInstance(cal.getTimeZone());
        other.setTimeInMillis(cal.getTimeInMillis());
        other.add(2, incr);
        return other;
    }

    public static Calendar addYear(Calendar cal, int incr) {
        Calendar other = Calendar.getInstance(cal.getTimeZone());
        other.setTimeInMillis(cal.getTimeInMillis());
        other.add(1, incr);
        return other;
    }

    public static Calendar relativeDay(Calendar cal, int offset) {
        Calendar other = Calendar.getInstance(cal.getTimeZone());
        other.setTimeInMillis(cal.getTimeInMillis());
        other.add(5, offset);
        return other;
    }

    public static boolean isSameDate(Calendar day1, Calendar day2) {
        return day1.get(1) == day2.get(1) && day1.get(2) == day2.get(2) && day1.get(5) == day2.get(5);
    }

    public static boolean isSameMonth(Calendar day1, Calendar day2) {
        return day1.get(1) == day2.get(1) && day1.get(2) == day2.get(2);
    }

    public static int getNumDays(Calendar day1, Calendar day2) {
        long startTime = day1.getTimeInMillis();
        long endTime = day2.getTimeInMillis();
        int numDays = (int)((endTime - startTime) / 86400000L);
        return numDays;
    }

    public static int getYear(Calendar cal) {
        return cal.get(1);
    }

    public static int getMonth(Calendar cal) {
        return cal.get(2);
    }

    public static int getDay(Calendar cal) {
        return cal.get(5);
    }

    public static int getDayOfWeek(Calendar cal) {
        return cal.get(7);
    }

    public static List<Boolean> getWorkDays(String wdays) {
        ArrayList<Boolean> workDays = new ArrayList<Boolean>();
        String[] inpWdays = wdays.split(",");
        for (int index = 0; index < 7; ++index) {
            workDays.add(index, false);
        }
        for (String day : inpWdays) {
            workDays.remove(Integer.parseInt(day));
            workDays.add(Integer.parseInt(day), true);
        }
        return workDays;
    }

    public static String generateWorkWeek(String workWeekPref, String days) {
        StringBuilder wDays = new StringBuilder();
        String[] daysArr = days.split(",");
        String[] workDays = workWeekPref.split(",");
        for (int i = 0; i < 7; ++i) {
            Object[] day = workDays[i].split(":");
            day[1] = daysArr[i];
            String modDay = StringUtil.join((String)":", (Object[])day);
            if (wDays.length() > 0) {
                wDays.append(',');
            }
            wDays.append(modDay);
        }
        return wDays.toString();
    }

    public static String convertCalWorkHours(String workWeekPref) {
        StringBuilder wDays = new StringBuilder();
        String[] workDays = workWeekPref.split(",");
        for (int i = 0; i < 7; ++i) {
            String[] day = workDays[i].split(":");
            if (!day[1].equals("Y")) continue;
            if (wDays.length() > 0) {
                wDays.append(',');
            }
            wDays.append(Integer.toString(i));
        }
        return wDays.toString();
    }

    public static String getCanonicalFolderIds(ZMailboxBean mailbox, String checkedCalendars) throws ServiceException {
        StringBuilder sb = new StringBuilder();
        String[] folders = checkedCalendars.split(",");
        ZMailbox mbox = mailbox.getMailbox();
        for (int i = 0; i < folders.length; ++i) {
            String folderid;
            ZFolder f = mbox.getFolderById(folders[i]);
            String string = folderid = f instanceof ZMountpoint ? ((ZMountpoint)f).getCanonicalRemoteId() : folders[i];
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(folderid);
        }
        return sb.toString();
    }

    public static String getCheckedCalendarFolderIds(ZMailboxBean mailbox) throws ServiceException {
        StringBuilder sb = new StringBuilder();
        BeanUtils.getCheckedCalendarFoldersRecursive(mailbox.getMailbox().getUserRoot(), sb);
        return sb.toString();
    }

    private static void getCheckedCalendarFoldersRecursive(ZFolder f, StringBuilder sb) {
        if (f.getDefaultView() == ZFolder.View.appointment && f.isCheckedInUI()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f.getId());
        }
        for (ZFolder child : f.getSubFolders()) {
            BeanUtils.getCheckedCalendarFoldersRecursive(child, sb);
        }
    }

    public static boolean hasAnyAppointments(ZApptSummariesBean summary, long start, long end) {
        for (ZAppointmentHit appt : summary.getAppointments()) {
            if (!appt.isInRange(start, end)) continue;
            return true;
        }
        return false;
    }

    public static long MSECS_PER_MINUTE() {
        return 60000L;
    }

    public static long MSECS_PER_HOUR() {
        return 3600000L;
    }

    public static long MSECS_PER_DAY() {
        return 86400000L;
    }

    public static String getCanonicalId(TimeZone tz) {
        return TZIDMapper.canonicalize((String)tz.getID());
    }

    public static TimeZone getTimeZone(String id) {
        return (id = TZIDMapper.canonicalize((String)id)) == null ? TimeZone.getDefault() : TimeZone.getTimeZone(id);
    }

    public static String getFolderStyleColor(String color, String view) throws ServiceException {
        return ZFolderBean.getStyleColor(ZFolder.Color.fromString((String)color), ZFolder.View.fromString((String)view));
    }

    public static String getFolderRgbColor(String color, String view) throws ServiceException {
        return ZFolderBean.getRgbColor(ZFolder.Color.fromString((String)color), ZFolder.View.fromString((String)view));
    }

    public static String getFolderRgbColorMsg(String color, String view) throws ServiceException {
        return ZFolderBean.getRgbColorMsg(ZFolder.Color.fromString((String)color), ZFolder.View.fromString((String)view));
    }

    public static boolean actionSet(Map param, String action) {
        return param.containsKey(action) || param.containsKey(action + ".x");
    }

    public static boolean isSameTimeZone(String tz1, String tz2) {
        return tz1 == null || tz2 == null ? tz1 == tz2 : TZIDMapper.canonicalize((String)tz1).equals(TZIDMapper.canonicalize((String)tz2));
    }

    public static ZInvite.ZAttendee getMyAttendee(ZInvite invite, ZMailboxBean mailbox) throws ServiceException {
        ZInvite.ZComponent comp = invite.getComponent();
        List attendees = comp.getAttendees();
        if (attendees != null) {
            Set myAddrs = mailbox.getAccountInfo().getEmailAddresses();
            for (ZInvite.ZAttendee attendee : attendees) {
                if (!myAddrs.contains(attendee.getAddress()) && !myAddrs.contains(attendee.getUrl())) continue;
                return attendee;
            }
        }
        return null;
    }

    public static String getRepeatBlurb(ZSimpleRecurrence repeat, PageContext pc, TimeZone timeZone, Date startDate) {
        String r = "";
        if (repeat == null || repeat.getType() == null) {
            return I18nUtil.getLocalizedMessage(pc, "recurNone");
        }
        switch (repeat.getType()) {
            case NONE: {
                r = I18nUtil.getLocalizedMessage(pc, "recurNone");
                break;
            }
            case DAILY: {
                r = I18nUtil.getLocalizedMessage(pc, "recurDailyEveryDay");
                break;
            }
            case DAILY_WEEKDAY: {
                r = I18nUtil.getLocalizedMessage(pc, "recurDailyEveryWeekday");
                break;
            }
            case DAILY_INTERVAL: {
                r = I18nUtil.getLocalizedMessage(pc, "recurDailyEveryNumDays", new Object[]{repeat.getDailyInterval()});
                break;
            }
            case WEEKLY: {
                r = I18nUtil.getLocalizedMessage(pc, "recurDailyEveryWeek");
                break;
            }
            case WEEKLY_BY_DAY: {
                Calendar cal = BeanUtils.getToday(timeZone);
                BeanUtils.setDayOfWeek(cal, repeat.getWeeklyByDay().ordinal() + 1);
                r = I18nUtil.getLocalizedMessage(pc, "recurWeeklyEveryWeekday", new Object[]{cal.getTime()});
                break;
            }
            case WEEKLY_CUSTOM: {
                StringBuilder wc = new StringBuilder();
                Calendar cal = BeanUtils.getToday(timeZone);
                wc.append(I18nUtil.getLocalizedMessage(pc, "recurWeeklyEveryNumWeeks", new Object[]{repeat.getWeeklyInterval()}));
                wc.append(" ");
                int wci = 1;
                int wcmax = repeat.getWeeklyIntervalDays().size();
                for (ZInvite.ZWeekDay day : repeat.getWeeklyIntervalDays()) {
                    if (wci != 1 && wci != wcmax) {
                        wc.append(I18nUtil.getLocalizedMessage(pc, "recurWeeklyEveryNumWeeksSep")).append(" ");
                    }
                    if (wci != 1 && wci == wcmax) {
                        wc.append(" ").append(I18nUtil.getLocalizedMessage(pc, "recurWeeklyEveryNumWeeksLastSep")).append(" ");
                    }
                    BeanUtils.setDayOfWeek(cal, day.getOrdinal() + 1);
                    wc.append(I18nUtil.getLocalizedMessage(pc, "recurWeeklyEveryNumWeeksDay", new Object[]{cal.getTime()}));
                    ++wci;
                }
                r = wc.toString();
                break;
            }
            case MONTHLY: {
                r = I18nUtil.getLocalizedMessage(pc, "recurMonthly");
                break;
            }
            case MONTHLY_BY_MONTH_DAY: {
                r = I18nUtil.getLocalizedMessage(pc, "recurMonthlyEveryNumMonthsDate", new Object[]{repeat.getMonthlyMonthDay(), repeat.getMonthlyInterval()});
                break;
            }
            case MONTHLY_RELATIVE: {
                Calendar cal = BeanUtils.getToday(timeZone);
                BeanUtils.setDayOfWeek(cal, repeat.getMonthlyRelativeDay().getDay().getOrdinal() + 1);
                r = I18nUtil.getLocalizedMessage(pc, "recurMonthlyEveryNumMonthsNumDay", new Object[]{repeat.getMonthlyRelativeDay().getWeekOrd(), cal.getTime(), repeat.getMonthlyInterval()});
                break;
            }
            case YEARLY: {
                r = I18nUtil.getLocalizedMessage(pc, "recurYearly");
                break;
            }
            case YEARLY_BY_DATE: {
                Calendar cal = BeanUtils.getToday(timeZone);
                BeanUtils.setMonth(cal, repeat.getYearlyByDateMonth() - 1);
                r = I18nUtil.getLocalizedMessage(pc, "recurYearlyEveryDate", new Object[]{cal.getTime(), repeat.getYearlyByDateMonthDay()});
                break;
            }
            case YEARLY_RELATIVE: {
                Calendar cal = BeanUtils.getToday(timeZone);
                BeanUtils.setDayOfWeek(cal, repeat.getYearlyRelativeDay().getDay().getOrdinal() + 1);
                BeanUtils.setMonth(cal, repeat.getYearlyRelativeMonth() - 1);
                r = I18nUtil.getLocalizedMessage(pc, "recurYearlyEveryMonthNumDay", new Object[]{repeat.getYearlyRelativeDay().getWeekOrd(), cal.getTime(), cal.getTime()});
                break;
            }
            default: {
                r = I18nUtil.getLocalizedMessage(pc, "recurComplex");
            }
        }
        if (repeat.getType() == ZSimpleRecurrence.ZSimpleRecurrenceType.NONE) {
            return r;
        }
        String e = "";
        switch (repeat.getEnd()) {
            case NEVER: {
                e = I18nUtil.getLocalizedMessage(pc, "recurEndNone");
                break;
            }
            case COUNT: {
                e = I18nUtil.getLocalizedMessage(pc, "recurEndNumber", new Object[]{repeat.getCount()});
                break;
            }
            case UNTIL: {
                DateFormat untilDf = DateFormat.getDateInstance(2, pc.getRequest().getLocale());
                if (timeZone != null) {
                    untilDf.setTimeZone(timeZone);
                }
                String untilDate = untilDf.format(repeat.getUntilDate().getDate());
                e = I18nUtil.getLocalizedMessage(pc, "recurEndByDate", new Object[]{untilDate});
            }
        }
        String s = "";
        if (startDate != null) {
            DateFormat startDf = DateFormat.getDateInstance(2, pc.getRequest().getLocale());
            if (timeZone != null) {
                startDf.setTimeZone(timeZone);
            }
            s = I18nUtil.getLocalizedMessage(pc, "recurStart", new Object[]{startDf.format(startDate)});
        }
        return I18nUtil.getLocalizedMessage(pc, "repeatBlurb", new Object[]{r, e, s});
    }

    public static String getApptDateBlurb(PageContext pc, TimeZone timeZone, long startTime, long endTime, boolean allDay) {
        Calendar startCal = BeanUtils.getCalendar(startTime, timeZone);
        Calendar endCal = BeanUtils.getCalendar(endTime, timeZone);
        DateFormat df = DateFormat.getDateInstance(0, I18nUtil.findLocale(pc));
        DateFormat tf = DateFormat.getTimeInstance(3, I18nUtil.findLocale(pc));
        if (timeZone != null) {
            df.setTimeZone(timeZone);
            tf.setTimeZone(timeZone);
        }
        boolean sameDate = BeanUtils.isSameDate(startCal, endCal);
        if (allDay && sameDate) {
            return I18nUtil.getLocalizedMessage(pc, "apptDateBlurbAllDay", new Object[]{df.format(startCal.getTime())});
        }
        if (allDay) {
            return I18nUtil.getLocalizedMessage(pc, "apptDateBlurbAllDayDiffEndDay", new Object[]{df.format(startCal.getTime()), df.format(endCal.getTime())});
        }
        if (sameDate) {
            return I18nUtil.getLocalizedMessage(pc, "apptDateBlurb", new Object[]{df.format(startCal.getTime()), tf.format(startCal.getTime()), tf.format(endCal.getTime())});
        }
        return I18nUtil.getLocalizedMessage(pc, "apptDateBlurbDiffEndDay", new Object[]{df.format(startCal.getTime()), tf.format(startCal.getTime()), df.format(endCal.getTime()), tf.format(endCal.getTime())});
    }

    public static void clearMessageCache(ZMailboxBean mailbox) {
        mailbox.getMailbox().clearMessageCache();
    }

    public static void clearContactCache(ZMailboxBean mailbox) {
        mailbox.getMailbox().clearContactCache();
    }

    public static void clearApptSummaryCache(ZMailboxBean mailbox) {
        mailbox.getMailbox().clearApptSummaryCache();
    }

    public static void refreshPrefs(ZMailboxBean mailbox) throws JspTagException {
        try {
            mailbox.getMailbox().getPrefs(true);
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public static boolean hasShareMountPoint(ZMailboxBean mailbox, ZMessageBean message) {
        ZShare share = message.getShare();
        if (share == null) {
            return false;
        }
        try {
            ZFolder folder = mailbox.getMailbox().getFolderById(share.getGrantor().getId() + ":" + share.getLink().getId());
            return folder != null;
        }
        catch (ServiceException e) {
            return false;
        }
    }

    public static String jsEncode(String str) {
        return StringUtil.jsEncode((Object)str);
    }

    public static String getFolderRestURL(ZMailboxBean mailbox, ZFolderBean folder) throws JspTagException {
        try {
            return mailbox.getRestURI(folder.getRootRelativePathURLEncoded()).toString();
        }
        catch (ServiceException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public static String getVoiceFolderType(ZFolderBean folder) {
        String name = folder.getName();
        if ("Placed Calls".equals(name) || "Answered Calls".equals(name) || "Missed Calls".equals(name)) {
            return "calllog";
        }
        return "voicemail";
    }

    public static String getVoiceFolderQuery(ZFolderBean folder) {
        String id = folder.getId();
        String phone = id.substring(id.indexOf(45) + 1);
        String name = folder.getName();
        return "phone:" + phone + " " + "in:\"" + name + "\"";
    }

    public static String getVoiceFolderName(PageContext pc, ZFolderBean folder) {
        String name = folder.getName();
        String key = null;
        if ("Placed Calls".equals(name)) {
            key = "placedCalls";
        } else if ("Answered Calls".equals(name)) {
            key = "answeredCalls";
        } else if ("Missed Calls".equals(name)) {
            key = "missedCalls";
        } else if ("Voicemail Inbox".equals(name)) {
            key = "voiceMail";
        } else if ("Trash".equals(name)) {
            key = "trash";
        }
        return key != null ? I18nUtil.getLocalizedMessage(pc, key) : name;
    }

    public static String getPhoneDisplay(String name) {
        return ZPhone.getDisplay((String)name);
    }

    public static String getPhoneFromVoiceQuery(String query) {
        String phone = "phone:";
        int match = query.indexOf(phone);
        if (match != -1) {
            int startIndex = match + phone.length();
            int endIndex = query.indexOf(32, startIndex);
            if (endIndex == -1) {
                endIndex = query.length();
            }
            return query.substring(startIndex, endIndex);
        }
        return "";
    }

    public static ZVoiceMailItemHitBean deserializeVoiceMailItemHit(String value, String phone) throws ServiceException {
        return ZVoiceMailItemHitBean.deserialize(value, phone);
    }

    public static ZVoiceMailItemHitBean[] deserializeVoiceMailItemHits(String[] values, String phone) throws ServiceException {
        if (values == null) {
            return new ZVoiceMailItemHitBean[0];
        }
        ZVoiceMailItemHitBean[] result = new ZVoiceMailItemHitBean[values.length];
        int count = values.length;
        for (int i = 0; i < count; ++i) {
            result[i] = BeanUtils.deserializeVoiceMailItemHit(values[i], phone);
        }
        return result;
    }

    public static String deserializeVoiceMailItemIds(String[] values, String phone) throws ServiceException {
        if (values == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(128);
        for (String value : values) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            ZVoiceMailItemHitBean bean = ZVoiceMailItemHitBean.deserialize(value, phone);
            builder.append(bean.getId());
        }
        return builder.toString();
    }

    public static ZPhoneAccountBean getFirstPhoneAccount(PageContext pc) throws ServiceException, JspException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        List accounts = mbox.getAllPhoneAccounts();
        return accounts.size() > 0 ? new ZPhoneAccountBean((ZPhoneAccount)accounts.get(0)) : null;
    }

    public static ZPhoneAccountBean getPhoneAccount(PageContext pc, String phone) throws ServiceException, JspException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        ZPhoneAccount account = mbox.getPhoneAccount(phone);
        return account == null ? null : new ZPhoneAccountBean(account);
    }

    public static String getDisplayCaller(PageContext pc, ZPhone phone) throws ServiceException, JspException {
        String fileAsString;
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        ZContactByPhoneCache.ContactPhone data = mbox.getContactByPhone(phone.getName());
        String phoneDisplay = phone.getDisplay();
        if (data != null && (fileAsString = Contact.getFileAsString((Map)data.getContact().getAttrs())) != null && fileAsString.length() > 0) {
            String field = I18nUtil.getLocalizedMessage(pc, sPHONE_FIELDS.get(data.getField()));
            return I18nUtil.getLocalizedMessage(pc, "callingPartyFormat", new Object[]{BeanUtils.cook(fileAsString), field, phoneDisplay});
        }
        String callerId = phone.getCallerId();
        if (!StringUtil.isNullOrEmpty((String)callerId)) {
            return I18nUtil.getLocalizedMessage(pc, "callingPartyCallerIdFormat", new Object[]{BeanUtils.cook(callerId), phoneDisplay});
        }
        if (phoneDisplay != null && phoneDisplay.length() != 0) {
            return phoneDisplay;
        }
        String name = phone.getName();
        if (!StringUtil.isNullOrEmpty((String)name)) {
            return name;
        }
        return I18nUtil.getLocalizedMessage(pc, "noCallerId");
    }

    private static String getPhoneName(String display) {
        return sPHONE_NAME.matcher(display).replaceAll("");
    }

    public static boolean isValidPhoneNumber(String number) {
        if (number == null) {
            return false;
        }
        int length = BeanUtils.getPhoneName(number).length();
        return 7 <= length && length <= 20 && sPHONE.matcher(number).matches();
    }

    public static boolean isValidEmailAddress(String email) {
        Matcher m = sEMAIL_ADDRESS.matcher(email);
        boolean matchFound = m.matches();
        return matchFound;
    }

    public static boolean isValidEmailAddresses(String emailline) {
        boolean validEmail = true;
        try {
            InternetAddress[] inetAddrs;
            emailline = emailline.replace(";", ",");
            for (InternetAddress ia : inetAddrs = JavaMailInternetAddress.parseHeader((String)emailline, (boolean)false)) {
                Matcher m = sEMAIL_ADDRESS.matcher(ia.getAddress());
                boolean matchFound = m.matches();
                validEmail = matchFound;
            }
            return validEmail;
        }
        catch (AddressException e) {
            return false;
        }
    }

    public static boolean isFileAsExplicit(String fileAs) {
        return fileAs.equals(Integer.toString(8));
    }

    public static boolean isAllowedUA(ZUserAgentBean ua, String[] allowedUA) {
        if (allowedUA == null || allowedUA.length == 0) {
            return true;
        }
        for (String str : allowedUA) {
            Pattern pattern = Pattern.compile(str);
            if (ua.getUserAgent() == null) {
                return false;
            }
            Matcher m = pattern.matcher(ua.getUserAgent());
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllowedIP(String remoteAddr, String[] allowedIP) {
        if (allowedIP == null || allowedIP.length == 0) {
            return true;
        }
        for (String str : allowedIP) {
            Pattern pattern = Pattern.compile(str);
            Matcher m = pattern.matcher(remoteAddr);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean isMailEnabled(ZMailboxBean mailbox) throws ServiceException {
        ZFeatures features = mailbox.getFeatures();
        return features.getMail() && (mailbox.getAdminDelegated() == false || mailbox.getAdminDelegated() != false && features.getAdminMail());
    }

    public static String lightenColor(String color) {
        Color col = Color.decode(color);
        String retColor = "#";
        int[] rgb = new int[]{col.getRed(), col.getGreen(), col.getBlue()};
        for (int index = 0; index < 3; ++index) {
            rgb[index] = (int)Math.max(0.0, Math.min(255.0, (double)rgb[index] + (double)(255 - rgb[index]) * 0.3));
            retColor = retColor + Integer.toHexString(rgb[index]);
        }
        return retColor;
    }

    public static boolean getIsMyCard(PageContext pc, String ids) throws ServiceException, JspException {
        ZMailbox mbox = ZJspSession.getZMailbox(pc);
        return mbox.getIsMyCard(ids);
    }

    public static Calendar getYFirstDayOfMonthView(Calendar date, long prefFirstDayOfWeek) {
        ++prefFirstDayOfWeek;
        Calendar cal = Calendar.getInstance(date.getTimeZone());
        cal.setTimeInMillis(date.getTimeInMillis());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        int dow = cal.get(7);
        if ((long)dow != prefFirstDayOfWeek) {
            cal.add(5, -((dow + (7 - (int)prefFirstDayOfWeek)) % 7));
        }
        return cal;
    }

    public static int getNumberOfWeeksOfMonth(Calendar date) {
        Calendar cal = (Calendar)date.clone();
        return cal.getActualMaximum(4);
    }

    public static String getImagePath(PageContext pc, String relativePath) {
        String ZIMBRA_IMAGE_SERVERS = "zimbraImageServers";
        String[] servers = (String[])pc.getAttribute("zimbraImageServers", 4);
        if (servers == null) {
            String serverList = pc.getServletContext().getInitParameter("zimbraImageServers");
            servers = serverList == null || serverList.length() == 0 ? new String[]{} : sCOMMA.split(serverList);
            int count = servers.length;
            for (int i = 0; i < count; ++i) {
                servers[i] = servers[i].trim();
            }
            pc.setAttribute("zimbraImageServers", (Object)servers, 4);
        }
        if (servers.length > 0) {
            int index = Math.abs(relativePath.hashCode()) % servers.length;
            return "//" + servers[index] + ":" + pc.getRequest().getServerPort() + relativePath;
        }
        return relativePath;
    }

    public static String cook(String in) {
        return StringUtil.escapeHtml((String)in);
    }

    public static String unCook(String in) {
        return StringUtil.unEscapeHtml((String)in);
    }

    public static int cookInt(String in, int defaultValue) {
        if (in == null || in.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean contains(Object container, Object object) {
        if (container == null || object == null) {
            return false;
        }
        if (container instanceof Collection) {
            return ((Collection)container).contains(object);
        }
        if (container instanceof Object[]) {
            Object[] array;
            for (Object item : array = (Object[])container) {
                if (!item.equals(object)) continue;
                return true;
            }
            return false;
        }
        return String.valueOf(container).contains(String.valueOf(object));
    }

    public static String javaLocaleId(Locale locale) {
        String locid = locale.toString();
        return locid.startsWith("in") ? locid.replaceAll("^in", "id") : locid;
    }

    public static String browserLocaleId(Locale locale) {
        return BeanUtils.javaLocaleId(locale).toLowerCase().replace('_', '-');
    }

    public static String yuiCompress(String s, String type) {
        try {
            StringWriter out = new StringWriter();
            StringReader in = new StringReader(s);
            int linebreakpos = -1;
            if (type.equalsIgnoreCase("css")) {
                CssCompressor compressor = new CssCompressor((Reader)in);
                in.close();
                in = null;
                compressor.compress((Writer)out, linebreakpos);
                s = out.toString();
            } else if (type.equalsIgnoreCase("js")) {
                JavaScriptCompressor jsc = new JavaScriptCompressor((Reader)in, new ErrorReporter(){

                    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        if (line < 0) {
                            System.err.println("\nyuiCompress:[WARNING] " + message);
                        } else {
                            System.err.println("\nyuiCompress:[WARNING] " + line + ':' + lineOffset + ':' + message);
                        }
                    }

                    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        if (line < 0) {
                            System.err.println("\nyuiCompress:[ERROR] " + message);
                        } else {
                            System.err.println("\nyuiCompress:[ERROR] " + line + ':' + lineOffset + ':' + message);
                        }
                    }

                    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        this.error(message, sourceName, line, lineSource, lineOffset);
                        return new EvaluatorException(message);
                    }
                });
                jsc.compress((Writer)out, linebreakpos, true, false, true, false);
                s = out.toString();
            }
        }
        catch (Exception ex) {
            System.err.println("\nyuiCompress:[EXCEPTION] " + ex);
            ex.printStackTrace(System.err);
        }
        return s;
    }

    public static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        return s.length() > 1 ? s.substring(0, 1).toUpperCase() + s.substring(1) : s.toUpperCase();
    }

    static {
        try {
            InitialContext sInitCtxt = new InitialContext();
            sEnvCtxt = (Context)sInitCtxt.lookup("java:comp/env");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        sPHONE_FIELDS = new HashMap<String, String>();
        sPHONE_FIELDS.put(ContactConstants.A_callbackPhone, "phoneLabelCallback");
        sPHONE_FIELDS.put(ContactConstants.A_carPhone, "phoneLabelCar");
        sPHONE_FIELDS.put(ContactConstants.A_assistantPhone, "phoneLabelAssistant");
        sPHONE_FIELDS.put(ContactConstants.A_companyPhone, "phoneLabelCompany");
        sPHONE_FIELDS.put(ContactConstants.A_homeFax, "phoneLabelHomeFax");
        sPHONE_FIELDS.put(ContactConstants.A_homePhone, "phoneLabelHome");
        sPHONE_FIELDS.put(ContactConstants.A_homePhone2, "phoneLabelHome2");
        sPHONE_FIELDS.put(ContactConstants.A_mobilePhone, "phoneLabelMobile");
        sPHONE_FIELDS.put(ContactConstants.A_otherPhone, "phoneLabelHomeAlternate");
        sPHONE_FIELDS.put(ContactConstants.A_workPhone, "phoneLabelWork");
        sPHONE_FIELDS.put(ContactConstants.A_workPhone2, "phoneLabelWork2");
        sPHONE_FIELDS.put(ContactConstants.A_homeFax, "phoneLabelHomeFax");
        sPHONE_FIELDS.put(ContactConstants.A_workFax, "AB_FIELD_workFax");
        sPHONE_FIELDS.put(ContactConstants.A_workMobile, "AB_FIELD_workMobile");
        sPHONE_FIELDS.put(ContactConstants.A_workAltPhone, "AB_FIELD_workAlternatePhone");
        sPHONE_FIELDS.put(ContactConstants.A_otherFax, "AB_FIELD_otherFax");
        sPHONE_FIELDS.put(ContactConstants.A_assistantPhone, "phoneLabelAssistant");
        sPHONE_FIELDS.put(ContactConstants.A_companyPhone, "AB_FIELD_company");
        sPHONE_NAME = Pattern.compile("[^\\d]");
        sPHONE = Pattern.compile("[0-9()\\-\\s\\+]+");
        sEMAIL_ADDRESS = Pattern.compile(".+@.+\\.[a-z]+");
    }

    private static enum DateTimeFmt {
        DTF_TIME_SHORT,
        DTF_DATE_MEDIUM,
        DTF_DATE_SHORT;

    }
}

