/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.taglib;

import com.google.common.base.Charsets;
import com.zimbra.client.ZAuthResult;
import com.zimbra.client.ZFolder;
import com.zimbra.client.ZMailbox;
import com.zimbra.common.account.Key;
import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.BlobMetaData;
import com.zimbra.common.util.BlobMetaDataEncodingException;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.RemoteIP;
import com.zimbra.common.util.WebSplitUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.ngxlookup.NginxAuthServer;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.taglib.bean.BeanUtils;
import com.zimbra.cs.taglib.memcached.RouteCache;
import com.zimbra.cs.taglib.ngxlookup.NginxRouteLookUpConnector;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class ZJspSession {
    public static final String ATTR_SESSION = ZJspSession.class.getCanonicalName() + ".session";
    private static final String ATTR_TEMP_AUTHTOKEN = ZJspSession.class.getCanonicalName() + ".authToken";
    public static final String COOKIE_NAME = "ZM_AUTH_TOKEN";
    public static final String ZM_LAST_SERVER_COOKIE_NAME = "ZM_LAST_SERVER";
    private static final String C_ID = "id";
    private static final String CONFIG_ZIMBRA_SOAP_URL = "zimbra.soap.url";
    private static final String CONFIG_ZIMBRA_JSP_SESSION_TIMEOUT = "zimbra.jsp.session.timeout";
    private static final String CONFIG_ZIMBRA_SEARCH_USE_OFFSET = "zimbra.search.useoffset";
    public static final String Q_ZAUTHTOKEN = "zauthtoken";
    public static final String Q_ZINITMODE = "zinitmode";
    public static final String Q_ZREMBERME = "zrememberme";
    public static final String Q_ZLASTSERVER = "zlastserver";
    private ZMailbox mMbox;
    private ZAuthToken mAuthToken;
    private static String sSoapUrl = null;
    private static final String DEFAULT_HTTPS_PORT = "443";
    private static final String DEFAULT_HTTP_PORT = "80";
    private static final String RANDOM_HTTP_PORT = "0";
    private static final String PROTO_MIXED = "mixed";
    private static final String PROTO_HTTP = "http";
    private static final String PROTO_HTTPS = "https";
    private static final String HTTP_SSL = "httpssl";
    private static final String sProtocolMode = BeanUtils.getEnvString("protocolMode", "http");
    private static final boolean MODE_HTTP = sProtocolMode.equals("http");
    private static final boolean MODE_MIXED = sProtocolMode.equals("mixed");
    private static final boolean MODE_HTTPS = sProtocolMode.equals("https");
    private static final String sHttpLocalBind = BeanUtils.getEnvString("httpLocalBind", "false");
    private static final boolean HTTP_LOCALBIND = sHttpLocalBind.equalsIgnoreCase("true");
    private static final String sHttpsPort = BeanUtils.getEnvString("httpsPort", "443");
    private static final String sHttpPort = BeanUtils.getEnvString("httpPort", "80");
    private static final String sLocalHost = BeanUtils.getEnvString("localHost", "localhost");
    private static final String sAdminUrl = BeanUtils.getEnvString("adminUrl", null);
    private static final RemoteIP.TrustedIPs TRUSTED_IPS = new RemoteIP.TrustedIPs(BeanUtils.getEnvString("trustedIPs", "").split(" "));
    private static int[] sAdminPorts = null;

    public ZJspSession(ZAuthToken authToken, ZMailbox mbox) {
        this.mAuthToken = authToken;
        this.mMbox = mbox;
    }

    public ZMailbox getMailbox() {
        return this.mMbox;
    }

    public ZAuthToken getAuthToken() {
        return this.mAuthToken;
    }

    public static boolean secureAuthTokenCookie(HttpServletRequest request) {
        String initMode = request.getParameter(Q_ZINITMODE);
        boolean currentHttps = request.getScheme().equals(PROTO_HTTPS);
        return MODE_HTTPS || currentHttps && (initMode == null || initMode.equals(PROTO_HTTPS));
    }

    public static boolean isProtocolModeHttps() {
        return MODE_HTTPS;
    }

    private static void addParam(StringBuilder query, String name, String value) {
        block4: {
            if (query.length() > 0) {
                query.append('&');
            }
            if (value == null) {
                value = "";
            }
            try {
                query.append(name).append("=").append(URLEncoder.encode(value, Charsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException never) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    private static boolean isInQueryString(HttpServletRequest req, String name) {
        String qs = req.getQueryString();
        return qs != null && qs.length() != 0 && qs.indexOf(name + "=") != -1;
    }

    private static String generateQueryString(HttpServletRequest req, Map<String, String> toAdd, Set<String> toRemove) {
        StringBuilder query = new StringBuilder();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String[] values;
            String name = (String)names.nextElement();
            if (toRemove == null || toRemove.contains(name) || !ZJspSession.isInQueryString(req, name) || (values = req.getParameterValues(name)) == null) continue;
            for (String value : values) {
                ZJspSession.addParam(query, name, value);
            }
        }
        if (toAdd != null) {
            for (Map.Entry<String, String> entry : toAdd.entrySet()) {
                ZJspSession.addParam(query, entry.getKey(), entry.getValue());
            }
        }
        return query.length() > 0 ? "?" + query.toString() : "";
    }

    private static String getRedirect(HttpServletRequest request, String protoHostPort, String path, Map<String, String> paramsToAdd, Set<String> paramsToRemove) {
        String contextPath;
        if (path == null || path.equals("")) {
            path = "/";
        }
        if ((contextPath = request.getContextPath()).equals("/")) {
            contextPath = "";
        }
        String qs = ZJspSession.generateQueryString(request, paramsToAdd, paramsToRemove);
        return protoHostPort + contextPath + path + qs;
    }

    private static String getRedirectToHostHeader(HttpServletRequest request, String proto, String path, Map<String, String> paramsToAdd, Set<String> paramsToRemove) {
        String protoHostPort = proto + "://" + request.getHeader("Host");
        return ZJspSession.getRedirect(request, protoHostPort, path, paramsToAdd, paramsToRemove);
    }

    private static String getRedirect(HttpServletRequest request, String proto, String host, String path, Map<String, String> paramsToAdd, Set<String> paramsToRemove) {
        String port;
        if (proto.equals(PROTO_HTTPS)) {
            port = sHttpsPort != null && sHttpsPort.equals(DEFAULT_HTTPS_PORT) ? "" : ":" + sHttpsPort;
        } else if (proto.equals(PROTO_HTTP)) {
            port = sHttpPort.equals(RANDOM_HTTP_PORT) ? ":" + LC.zimbra_admin_service_port.value() : (sHttpPort.equals(DEFAULT_HTTP_PORT) ? "" : ":" + sHttpPort);
        } else {
            return null;
        }
        String protoHostPort = proto + "://" + host + port;
        return ZJspSession.getRedirect(request, protoHostPort, path, paramsToAdd, paramsToRemove);
    }

    public static String getPostLoginRedirectUrl(PageContext context, String path, ZAuthResult authResult, boolean rememberMe, boolean needRefer) {
        String host;
        String proto;
        boolean needsAuthtokenRemoved;
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        String initMode = request.getParameter(Q_ZINITMODE);
        boolean hasIniitMode = initMode != null;
        boolean bl = needsAuthtokenRemoved = request.getParameter(Q_ZAUTHTOKEN) != null;
        if (!(needRefer || needsAuthtokenRemoved || hasIniitMode)) {
            return null;
        }
        HashMap<String, String> toAdd = new HashMap<String, String>();
        HashSet<String> toRemove = new HashSet<String>();
        if (hasIniitMode && !needRefer) {
            proto = MODE_MIXED && initMode.equals(PROTO_HTTP) && !request.getScheme().equals(PROTO_HTTP) ? PROTO_HTTP : (MODE_MIXED && initMode.equals(PROTO_HTTPS) && !request.getScheme().equals(PROTO_HTTPS) ? PROTO_HTTPS : (MODE_HTTPS ? PROTO_HTTPS : PROTO_HTTP));
            toRemove.add(Q_ZINITMODE);
        } else {
            proto = request.getScheme();
        }
        if (needRefer) {
            host = authResult.getRefer();
            if (rememberMe) {
                toAdd.put(Q_ZREMBERME, "1");
                Cookie lastServerCookie = new Cookie(ZM_LAST_SERVER_COOKIE_NAME, host);
                long timeLeft = authResult.getExpires() - System.currentTimeMillis();
                if (timeLeft > 0L) {
                    lastServerCookie.setMaxAge((int)(timeLeft / 1000L));
                }
                lastServerCookie.setPath("/");
                response.addCookie(lastServerCookie);
            }
        } else {
            host = request.getServerName();
        }
        if (needsAuthtokenRemoved) {
            toRemove.add(Q_ZAUTHTOKEN);
            toRemove.add(Q_ZREMBERME);
        }
        if (needsAuthtokenRemoved && !hasIniitMode && !needRefer) {
            return ZJspSession.getRedirectToHostHeader(request, proto, path, toAdd, toRemove);
        }
        return ZJspSession.getRedirect(request, proto, host, path, toAdd, toRemove);
    }

    public static String getChangePasswordUrl(PageContext context, String path) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        try {
            ZMailbox mbox = ZJspSession.getZMailbox(context);
            String publicUrl = mbox.getAccountInfo(false).getPublicURLBase();
            if (publicUrl != null) {
                return ZJspSession.getRedirect(request, publicUrl, path, null, null);
            }
        }
        catch (JspException mbox) {
        }
        catch (ServiceException mbox) {
            // empty catch block
        }
        String proto = MODE_HTTP ? PROTO_HTTP : PROTO_HTTPS;
        return ZJspSession.getRedirectToHostHeader(request, proto, path, null, null);
    }

    private static synchronized boolean isAdminPort(int port, PageContext context) {
        if (sAdminPorts == null) {
            String[] ports;
            String portsStr = context.getServletContext().getInitParameter("admin.allowed.ports");
            String[] stringArray = ports = portsStr != null ? portsStr.split(",") : null;
            if (ports != null) {
                sAdminPorts = new int[ports.length];
                int i = 0;
                for (String p : ports) {
                    try {
                        ZJspSession.sAdminPorts[i] = Integer.parseInt(p.trim());
                    }
                    catch (NumberFormatException nfe) {
                        ZJspSession.sAdminPorts[i] = -1;
                    }
                    ++i;
                }
            } else {
                sAdminPorts = new int[0];
            }
        }
        for (int p : sAdminPorts) {
            if (p != port) continue;
            return true;
        }
        return false;
    }

    public static String getAdminLoginRedirectUrl(PageContext context, String defaultPath) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        if (ZJspSession.isAdminPort(request.getServerPort(), context)) {
            String path;
            String qs = request.getQueryString();
            String string = path = sAdminUrl != null ? sAdminUrl : defaultPath;
            if (qs != null) {
                path = path + "?" + qs;
            }
            return path;
        }
        return null;
    }

    private static String getLastServer(HttpServletRequest request) {
        if ("1".equals(request.getParameter(Q_ZLASTSERVER))) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie c : cookies) {
            if (!c.getName().equals(ZM_LAST_SERVER_COOKIE_NAME)) continue;
            String lastServer = c.getValue();
            if (lastServer != null && !request.getServerName().equalsIgnoreCase(lastServer)) {
                return lastServer;
            }
            return null;
        }
        return null;
    }

    public static String getPreLoginRedirectUrl(PageContext context, String path) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        String lastServer = ZJspSession.getLastServer(request);
        boolean CURRENT_HTTP = request.getScheme().equals(PROTO_HTTP);
        if (lastServer != null) {
            HashMap<String, String> toAdd = new HashMap<String, String>();
            toAdd.put(Q_ZLASTSERVER, "1");
            return ZJspSession.getRedirect(request, request.getScheme(), lastServer, path, toAdd, null);
        }
        if ((MODE_MIXED || MODE_HTTPS) && CURRENT_HTTP || !CURRENT_HTTP && MODE_HTTP) {
            HashMap<String, String> toAdd = new HashMap<String, String>();
            toAdd.put(Q_ZINITMODE, PROTO_HTTP);
            return ZJspSession.getRedirect(request, PROTO_HTTPS, request.getServerName(), path, toAdd, null);
        }
        return null;
    }

    public static boolean getSearchUseOffset(PageContext context) {
        String useOffset = (String)Config.find((PageContext)context, (String)CONFIG_ZIMBRA_SEARCH_USE_OFFSET);
        return useOffset != null && (useOffset.equalsIgnoreCase("true") || useOffset.equalsIgnoreCase("1"));
    }

    public static synchronized String getSoapURL(PageContext context) throws ServiceException {
        ZimbraLog.misc.debug((Object)"Getting SOAP URL");
        if (WebSplitUtil.isZimbraWebClientSplitEnabled()) {
            String authProtocol;
            String accountID;
            ZimbraLog.misc.debug((Object)"Web split enabled");
            RouteCache rtCache = RouteCache.getInstance();
            try {
                accountID = ZJspSession.getAccountId(context);
                ZimbraLog.misc.debug((Object)"got accountId");
            }
            catch (AuthTokenException e) {
                throw ServiceException.AUTH_REQUIRED();
            }
            String route = null;
            String string = authProtocol = MODE_HTTP ? PROTO_HTTP : HTTP_SSL;
            if (!accountID.equals("99999999-9999-9999-9999-999999999999")) {
                route = rtCache.get(accountID);
                if (route == null) {
                    HttpServletRequest request = (HttpServletRequest)context.getRequest();
                    NginxAuthServer nginxLookUpServer = NginxRouteLookUpConnector.getClient().getRouteforAccount(accountID, "zimbraId", authProtocol, HttpUtil.getVirtualHost((HttpServletRequest)request), request.getRemoteAddr(), request.getHeader("Host"));
                    rtCache.put(nginxLookUpServer.getNginxAuthUser(), nginxLookUpServer.getNginxAuthServer());
                    route = nginxLookUpServer.getNginxAuthServer();
                }
            } else {
                route = NginxRouteLookUpConnector.getClient().getUpstreamMailServer(authProtocol);
            }
            ZimbraLog.misc.debug("got route %s", new Object[]{route});
            return (MODE_HTTP ? PROTO_HTTP : PROTO_HTTPS) + "://" + route + "/service/soap";
        }
        if (sSoapUrl == null && (sSoapUrl = (String)Config.find((PageContext)context, (String)CONFIG_ZIMBRA_SOAP_URL)) == null) {
            if (sProtocolMode.equalsIgnoreCase(PROTO_HTTPS) && !HTTP_LOCALBIND) {
                String httpsPort = sHttpsPort != null && sHttpsPort.equals(DEFAULT_HTTPS_PORT) ? "" : ":" + sHttpsPort;
                sSoapUrl = "https://" + sLocalHost + httpsPort + "/service/soap";
            } else {
                String httpPort = sHttpPort.equals(RANDOM_HTTP_PORT) ? ":" + LC.zimbra_admin_service_port.value() : (sHttpPort.equals(DEFAULT_HTTP_PORT) ? "" : ":" + sHttpPort);
                sSoapUrl = "http://" + sLocalHost + httpPort + "/service/soap";
            }
        }
        return sSoapUrl;
    }

    private static String getAccountId(PageContext context) throws AuthTokenException {
        ZAuthToken authToken = ZJspSession.getAuthToken(context);
        if (authToken == null) {
            authToken = new ZAuthToken((String)context.getAttribute("zimbra_authToken", 2));
        }
        if (!authToken.isEmpty()) {
            String encoded = authToken.getValue();
            int pos = encoded.indexOf(95);
            if (pos == -1) {
                throw new AuthTokenException("invalid authtoken format");
            }
            int pos1 = encoded.indexOf(95, pos + 1);
            if (pos1 == -1) {
                throw new AuthTokenException("invalid authtoken format");
            }
            String data = encoded.substring(pos1 + 1);
            try {
                String decoded = new String(Hex.decodeHex((char[])data.toCharArray()));
                return (String)BlobMetaData.decode((String)decoded).get(C_ID);
            }
            catch (DecoderException e) {
                throw new AuthTokenException("decoding exception", (Throwable)e);
            }
            catch (BlobMetaDataEncodingException e) {
                throw new AuthTokenException("blob decoding exception", (Throwable)e);
            }
        }
        throw new AuthTokenException("invalid authtoken");
    }

    public static ZMailbox getZMailbox(PageContext context) throws JspException {
        try {
            ZJspSession session = ZJspSession.getSession(context);
            if (session == null) {
                throw ServiceException.AUTH_REQUIRED();
            }
            return session.getMailbox();
        }
        catch (ServiceException e) {
            throw new JspTagException("getMailbox", (Throwable)e);
        }
    }

    public static ZAuthToken getAuthToken(PageContext context) {
        ZAuthToken authToken = (ZAuthToken)context.getAttribute(ATTR_TEMP_AUTHTOKEN, 2);
        if (authToken != null) {
            return authToken;
        }
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        ZAuthToken zat = new ZAuthToken(request, false);
        if (zat.isEmpty()) {
            return null;
        }
        return zat;
    }

    public static boolean hasSession(PageContext context) {
        HttpServletRequest req = (HttpServletRequest)context.getRequest();
        if (req.getSession(false) == null) {
            return false;
        }
        ZAuthToken authToken = ZJspSession.getAuthToken(context);
        ZJspSession sess = (ZJspSession)context.getAttribute(ATTR_SESSION, 3);
        return sess != null && sess.getAuthToken().equals((Object)authToken);
    }

    public static ZJspSession getSession(PageContext context) throws ServiceException {
        ZJspSession sess = (ZJspSession)context.getAttribute(ATTR_SESSION, 3);
        ZAuthToken authToken = ZJspSession.getAuthToken(context);
        if (sess != null && sess.getAuthToken().equals((Object)authToken)) {
            return sess;
        }
        if (authToken == null || authToken.isEmpty()) {
            return null;
        }
        ZMailbox.Options options = new ZMailbox.Options(authToken, ZJspSession.getSoapURL(context), true, "GET".equals(((HttpServletRequest)context.getRequest()).getMethod()));
        options.setClientIp(ZJspSession.getRemoteAddr(context));
        ZMailbox mbox = ZMailbox.getMailbox((ZMailbox.Options)options);
        mbox.getAccountInfo(false);
        return ZJspSession.setSession(context, mbox);
    }

    public static ZMailbox getRestMailbox(PageContext context, String authToken, String targetAccountId) throws ServiceException {
        return ZJspSession.getRestMailbox(context, authToken, false, targetAccountId);
    }

    public static ZMailbox getRestMailbox(PageContext context, String authToken, boolean csrfEnabled, String targetAccountId) throws ServiceException {
        if (authToken == null || authToken.length() == 0) {
            return null;
        }
        ZMailbox.Options options = new ZMailbox.Options(authToken, ZJspSession.getSoapURL(context));
        options.setNoSession(true);
        options.setAuthAuthToken(csrfEnabled);
        if (csrfEnabled) {
            options.setCsrfSupported(true);
        }
        options.setTargetAccount(targetAccountId);
        options.setTargetAccountBy(Key.AccountBy.id);
        options.setClientIp(ZJspSession.getRemoteAddr(context));
        return ZMailbox.getMailbox((ZMailbox.Options)options);
    }

    public static ZMailbox getRestMailbox(PageContext context, ZAuthToken authToken, String targetAccountId) throws ServiceException {
        if (authToken == null) {
            return null;
        }
        ZMailbox.Options options = new ZMailbox.Options(authToken, ZJspSession.getSoapURL(context));
        options.setNoSession(true);
        options.setAuthAuthToken(true);
        options.setCsrfSupported(true);
        options.setTargetAccount(targetAccountId);
        options.setTargetAccountBy(Key.AccountBy.id);
        options.setClientIp(ZJspSession.getRemoteAddr(context));
        return ZMailbox.getMailbox((ZMailbox.Options)options);
    }

    public static void setCollapsed(ZFolder folder, HashMap<String, String> expanded) {
        if (!folder.getSubFolders().isEmpty()) {
            expanded.put(folder.getId(), "collapse");
            for (ZFolder child : folder.getSubFolders()) {
                ZJspSession.setCollapsed(child, expanded);
            }
        }
    }

    public static ZJspSession setSession(PageContext context, ZMailbox mbox) throws ServiceException {
        ZJspSession sess = new ZJspSession(mbox.getAuthToken(), mbox);
        context.setAttribute(ATTR_TEMP_AUTHTOKEN, (Object)mbox.getAuthToken(), 2);
        context.setAttribute(ATTR_SESSION, (Object)sess, 3);
        HashMap<String, String> expanded = new HashMap<String, String>();
        for (ZFolder f : mbox.getUserRoot().getSubFolders()) {
            ZJspSession.setCollapsed(f, expanded);
        }
        context.setAttribute("expanded", expanded, 3);
        String timeOutStr = (String)Config.find((PageContext)context, (String)CONFIG_ZIMBRA_JSP_SESSION_TIMEOUT);
        if (timeOutStr != null) {
            try {
                context.getSession().setMaxInactiveInterval(Integer.parseInt(timeOutStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return sess;
    }

    public static void clearSession(PageContext context) {
    }

    public static String getRemoteAddr(PageContext context) {
        HttpServletRequest req = (HttpServletRequest)context.getRequest();
        RemoteIP remoteIp = new RemoteIP(req, TRUSTED_IPS);
        if (ZimbraLog.misc.isDebugEnabled()) {
            ZimbraLog.misc.debug("getting remoteAddr from remoteIp [%s] with trustedIps [%s]", new Object[]{remoteIp, TRUSTED_IPS});
        }
        return remoteIp.getRequestIP();
    }
}

